function EGM = CG_TriP1_GramMat(TriMesh)
%% CG: Tri.mesh. Lagrange P1 elements: Elementwise Gram mat. (for all elements)
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = TriMesh.NumEms;
k1 = TriMesh.elem(:,1);  k2 = TriMesh.elem(:,2);  k3 = TriMesh.elem(:,3);
x1 = TriMesh.node(k1,1);  y1 = TriMesh.node(k1,2); 
x2 = TriMesh.node(k2,1);  y2 = TriMesh.node(k2,2);
x3 = TriMesh.node(k3,1);  y3 = TriMesh.node(k3,2);
area = 0.5*((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1));

%% Setting up all entries 
EGM = zeros(NumEms,3,3);
EGM(:,1,1) = area/6;   EGM(:,1,2) = area/12;  EGM(:,1,3) = area/12;
EGM(:,2,1) = area/12;  EGM(:,2,2) = area/6;   EGM(:,2,3) = area/12;
EGM(:,3,1) = area/12;  EGM(:,3,2) = area/12;  EGM(:,3,3) = area/6;

return;