function CP1BasGrad = CG_TriP1_BasFxnGrad(TriMesh)
%% CG: Triangular mesh: Lagrangian P1 basis functions: Gradients 
% For all elements, 3 nodal basis fxns, gradients 
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = TriMesh.NumEms;
k1 = TriMesh.elem(:,1);  k2 = TriMesh.elem(:,2);  k3 = TriMesh.elem(:,3);
x1 = TriMesh.node(k1,1);  y1 = TriMesh.node(k1,2); 
x2 = TriMesh.node(k2,1);  y2 = TriMesh.node(k2,2);
x3 = TriMesh.node(k3,1);  y3 = TriMesh.node(k3,2);
area = 0.5*((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1));

%% NOTE: Lagrangian P1 bas.fxn.val. = Barycentric coordinates 
CP1BasGrad = zeros(NumEms,3,2);
CP1BasGrad(:,1,:) = [(y2-y3)./(2*area), (x3-x2)./(2*area)];
CP1BasGrad(:,2,:) = [(y3-y1)./(2*area), (x1-x3)./(2*area)];
CP1BasGrad(:,3,:) = [(y1-y2)./(2*area), (x2-x1)./(2*area)];

return;