function [sln] = Stokes_CG_QuadriBR1Q0_AsmSlv(...
  EqnBC,BndryCondType,QuadriMesh,GAUSSQUAD)
 %% Stokes_CG_QuadriBR1Q0_AsmSlv: Assembing and Solving
% James Liu, ColoState; 2012/07--2020/08 

%% Assembly is now separated 
[GlbMat,GlbRHS, GlbVecEss, FlagDOFs] ... 
  = Stokes_CG_QuadriBR1Q0_Asm( ... 
    EqnBC,BndryCondType,QuadriMesh,GAUSSQUAD);

%% Setup for DOFs 
% DOFs = size(GlbMat,1);

%% Enforcing the essential condition: Dirichlet bndry.cond. 
sln = GlbVecEss;

%% Reduction 
GlbRHS = GlbRHS - GlbMat*sln;

%% Solving the reduced linear system directly 
FreeNdEgEm = find(~FlagDOFs);
sln(FreeNdEgEm) = GlbMat(FreeNdEgEm,FreeNdEgEm) \ GlbRHS(FreeNdEgEm);

return;