function [] = show_TriMesh_labels(TriMesh,fwn,ch0,ch1,ch2)
%% RectMesh: Show node, element, edge labels in a specified window 
% fwn: figure window number 
% ch0: choice for showing node labels (0 or 1) 
% ch1: choice for showing edge labels (0 or 1) 
% ch2: choice for showing element labels (0 or 1) 
% James Liu, ColoState; 2012/07--2017/02

%% Mesh info 
NumNds = TriMesh.NumNds;
NumEms = TriMesh.NumEms;
node = TriMesh.node;
elem = TriMesh.elem;
if (ch1==1) 
  NumEgs = TriMesh.NumEgs;
  edge = TriMesh.edge;
end

%% Preparing 
xx = [node(elem(:,1),1)'; node(elem(:,2),1)'; node(elem(:,3),1)'];
yy = [node(elem(:,1),2)'; node(elem(:,2),2)'; node(elem(:,3),2)'];
% Element center 
xec = (1/3)*(node(elem(:,1),1) + node(elem(:,2),1) + node(elem(:,3),1));
yec = (1/3)*(node(elem(:,1),2) + node(elem(:,2),2) + node(elem(:,3),2));
% Edge center 
if (ch1==1) 
  xgc = 0.5*(node(edge(:,1),1)+node(edge(:,2),1)); 
  ygc = 0.5*(node(edge(:,1),2)+node(edge(:,2),2)); 
end

%% Plotting 
figure(fwn);
fill(xx,yy,'w');
set(gca,'fontsize',18);
% H1 = patch(xx,yy,val); 
% Nodal labels 
if ch0==1 
  for id=1:NumNds
    text(node(id,1),node(id,2),['\bf',num2str(id)],'fontsize',16);
  end
end
% Edge labels 
if ch1==1 
  for ig=1:NumEgs
    text(xgc(ig),ygc(ig),['\color{red}',num2str(ig)],'fontsize',16);
  end
end
% Element labels 
if ch2==1 
  for ie=1:NumEms
    text(xec(ie),yec(ie),num2str(ie),'EdgeColor','blue','fontsize',16);
  end
end
% title('A small triangular mesh');
title(['\bf', 'Nodes: bold black;  Elements: blue box;  Edges: red']);
% axis equal;  
axis off;

return;