function [] = show_TriMesh_ScaNd_trisurf(TriMesh,ScaNd,fwn,ts)
%% TriMesh: Show a scalar (with given nodal values) as a tri-surface 
% James Liu, ColoState; 2012/07--2018/12

%% Mesh info 
node = TriMesh.node;
elem = TriMesh.elem;

%% Plotting a trisurf 
figure(fwn);  % figure window number 
set(gca,'fontsize',20);
trisurf(elem(:,1:3),node(:,1),node(:,2),ScaNd);
colorbar('location','eastoutside','fontsize',18);
title(ts);  % title string 
axis on;  axis tight;
% axis equal;  

return;