function [] = show_TriMesh_ScaEm_ClrImg(TriMesh,ScaEm,fwn,ts)
%% TriMesh: Show scalar elementwise average as a color image 
% James Liu, ColoState; 2012/07--2017/02

%% Mesh info 
node = TriMesh.node;
elem = TriMesh.elem;

%% Preparing  
xx = [node(elem(:,1),1)'; node(elem(:,2),1)'; node(elem(:,3),1)'];
yy = [node(elem(:,1),2)'; node(elem(:,2),2)'; node(elem(:,3),2)'];
pres = [ScaEm'; ScaEm'; ScaEm'];

%% Plotting 
figure(fwn);  % figure window number
set(gca,'fontsize',18);
H1 = patch(xx,yy,pres); 
set(H1,'edgecolor','interp'); 
colorbar('location','eastoutside','fontsize',14);
colormap jet;
title(ts);  % title string 
axis square;
% axis equal;

return;