function [] = show_TriMesh(TriMesh,fwn)
%% TriMesh: Show the mesh in a specified figure window 
% James Liu, ColoState; 2012/07--2017/02

%% Mesh info 
NumNds = TriMesh.NumNds;
node = TriMesh.node;
elem = TriMesh.elem;

%% Plotting the mesh as a trisurf 
figure(fwn);  % figure window number 
trisurf(elem(:,1:3),node(:,1),node(:,2),zeros(NumNds,1));
title('A triangular mesh');
view(2);  axis equal;  % axis tight;  
axis off;

return;