function [] = show_RectMesh_labels(RectMesh,fwn)
%% RectMesh: Show node, element, edge labels in a specified window
% James Liu, ColoState; 2012/07--2017/02

%% Mesh info 
NumNds = RectMesh.NumNds;
NumEms = RectMesh.NumEms;
NumEgs = RectMesh.NumEgs;
node = RectMesh.node;
elem = RectMesh.elem;
edge = RectMesh.edge;

%% Preparing 
xx = [node(elem(:,1),1)'; node(elem(:,2),1)';...
      node(elem(:,3),1)'; node(elem(:,4),1)'];
yy = [node(elem(:,1),2)'; node(elem(:,2),2)';...
      node(elem(:,3),2)'; node(elem(:,4),2)'];
% Element center 
xec = 0.25*(node(elem(:,1),1) + node(elem(:,2),1)...
          + node(elem(:,3),1) + node(elem(:,4),1));
yec = 0.25*(node(elem(:,1),2) + node(elem(:,2),2)...
          + node(elem(:,3),2) + node(elem(:,4),2));
% Edge center/midpoint 
xgc = 0.5*(node(edge(:,1),1)+node(edge(:,2),1)); 
ygc = 0.5*(node(edge(:,1),2)+node(edge(:,2),2)); 

%% Plotting 
figure(fwn);
fill(xx,yy,'w');
set(gca,'fontsize',18);
% H1 = patch(xx,yy,val); 
% Nodal labels 
for id=1:NumNds
  text(node(id,1),node(id,2),['\bf',num2str(id)],'fontsize',16);
end
% Element labels 
for ie=1:NumEms
  text(xec(ie),yec(ie),num2str(ie),'EdgeColor','blue','fontsize',16);
end
% Edge labels 
for ig=1:NumEgs
  text(xgc(ig),ygc(ig),['\color{red}',num2str(ig)],'fontsize',16);
end
% title('A small rectangular mesh');
title(['\bf', 'Nodes: bold black;  Elements: blue box;  Edges: red']);
% axis equal;  
axis off;

return;