function [] = show_RectMesh_ScaVecEm_mix(RectMesh,ScaEm,VecEm,fwn,ts,mf)
%% RectMesh: Show scalar+vector (emws.const.) as mix of color image+quiver
% fwn: figure window number 
%  ts: title string for the figure window
%  mf: magnifying factor for vectors (length magnified mf times)  
% James Liu, ColoState; 2012/07--2018/12 

%% Mesh info 
node = RectMesh.node;
elem = RectMesh.elem;
% Assuming TriMesh.flag=3 

%% Preparing scalar ... 
xx = [node(elem(:,1),1)'; node(elem(:,2),1)';...
      node(elem(:,3),1)'; node(elem(:,4),1)'];
yy = [node(elem(:,1),2)'; node(elem(:,2),2)';...
      node(elem(:,3),2)'; node(elem(:,4),2)'];
scalar = repmat(ScaEm',4,1);

%% Plotting 
figure(fwn);
set(gca,'fontsize',20);
% for scalar 
H1 = patch(xx,yy,scalar); 
set(H1,'edgecolor','interp'); 
colormap jet;
colorbar('location','eastoutside','fontsize',18);
% for vector 
hold on;
quiver(RectMesh.EmCntr(:,1), RectMesh.EmCntr(:,2), ...
  VecEm(:,1),VecEm(:,2),mf,'k');  % vectors magnified mf times 
% for the figure 
title(ts);
axis equal;  axis tight;
% axis square;

return;