function [] = show_RectMesh_ScaNd_mesh(RectMesh,ScaNd,fwn,ts)
%% Show a rectangular mesh, scalar nodal values as a mesh-surface 
% James Liu, ColoState; 2012/07--2017/02

%% wireframe 
x = RectMesh.x;
y = RectMesh.y;
m = size(x,2);
n = size(y,1);
sca = reshape(ScaNd,[n,m]);

%% Plotting 
figure(fwn);  % figure window number
set(gca,'fontsize',18);
mesh(x,y,sca);
colorbar('location','eastoutside','fontsize',14);
title(ts);  % title string
xlabel('x');  ylabel('y');
axis tight;  % axis square;  axis equal;
view([15,30]);

return;