function [] = show_RectMesh_ScaEm_patch(RectMesh,ScaEm,fwn,ts)
%% RectMesh: Show a scalar (elementwise constant) as surface patches
% James Liu, ColoState; 2012/07--2017/02

%% Mesh info 
node = RectMesh.node;
elem = RectMesh.elem;

%% Preparing  
X = [node(elem(:,1),1)'; node(elem(:,2),1)';...
     node(elem(:,3),1)'; node(elem(:,4),1)'];
Y = [node(elem(:,1),2)'; node(elem(:,2),2)';...
     node(elem(:,3),2)'; node(elem(:,4),2)'];
Z = [ScaEm(:)'; ScaEm(:)'; ScaEm(:)'; ScaEm(:)'];
C = [ScaEm(:)'; ScaEm(:)'; ScaEm(:)'; ScaEm(:)'];

%% Plotting 
figure(fwn);  % figure window number
set(gca,'fontsize',18);
% patch(X,Y,Z,C);
fill3(X,Y,Z,C);
colorbar('location','eastoutside','fontsize',14);
title(ts);  % title string
axis square;
% axis equal;
view([15,30]);

return;