function [] = show_RectMesh_ScaEm_ClrImg(RectMesh,ScaEm,fwn,ts)
%% RectMesh: Show a scalar (elementwise constant) as a color image
% James Liu, ColoState; 2012/07--2017/02

%% Mesh info
node = RectMesh.node;
elem = RectMesh.elem;

%% Preparing pressure data 
xx = [node(elem(:,1),1)'; node(elem(:,2),1)';...
      node(elem(:,3),1)'; node(elem(:,4),1)'];
yy = [node(elem(:,1),2)'; node(elem(:,2),2)';...
      node(elem(:,3),2)'; node(elem(:,4),2)'];
sca = repmat(ScaEm',4,1);

%% Plotting 
figure(fwn);  % figure window number
set(gca,'fontsize',18);
H1 = patch(xx,yy,sca);
set(H1,'edgecolor','interp'); 
colormap jet;
colorbar('location','eastoutside','fontsize',14);
title(ts);  % title string 
% axis square;

return;