function [] = show_RectMesh(RectMesh,fwn)
%% RectMesh: Show the mesh in a specified figure window
% James Liu, ColoState; 2012/07--2017/02

%% Mesh info
NumEms = RectMesh.NumEms;
node = RectMesh.node;
elem = RectMesh.elem;

%% Arranging rectangles 
xx = [node(elem(:,1),1)'; node(elem(:,2),1)';...
  node(elem(:,3),1)'; node(elem(:,4),1)'];
yy = [node(elem(:,1),2)'; node(elem(:,2),2)';...
  node(elem(:,3),2)'; node(elem(:,4),2)'];
val = repmat(zeros(1,NumEms),4,1);

%% Showing the mesh in a specified window 
figure(fwn);  % figure window number 
patch(xx,yy,val);
% H1 = patch(xx,yy,val); 
title('A rectangular mesh');
axis equal;  axis off;

return;