function [] = show_QuadriMesh_labels(QuadriMesh,fwn,ch0,ch1,ch2)
%% QuadriMesh: Show node, element, edge labels in a specified window 
%  fwn: figure window number 
%  ch0: choice (0 or 1) for the nodes
%  ch1: choice (0 or 1) for the edges
%  ch2: choice (0 or 1) for the elements
% James Liu, ColoState; 2012/07--2020/08 

%% Mesh info 
NumNds = QuadriMesh.NumNds;
NumEms = QuadriMesh.NumEms;
node = QuadriMesh.node;
elem = QuadriMesh.elem;
if (ch1==1) 
  NumEgs = QuadriMesh.NumEgs;
  edge = QuadriMesh.edge;
end

%% Preparing 
xx = [node(elem(:,1),1)'; node(elem(:,2),1)';...
      node(elem(:,3),1)'; node(elem(:,4),1)'];
yy = [node(elem(:,1),2)'; node(elem(:,2),2)';...
      node(elem(:,3),2)'; node(elem(:,4),2)'];
% Element center 
xec = 0.25*(node(elem(:,1),1) + node(elem(:,2),1)...
          + node(elem(:,3),1) + node(elem(:,4),1));
yec = 0.25*(node(elem(:,1),2) + node(elem(:,2),2)...
          + node(elem(:,3),2) + node(elem(:,4),2));
if (ch1==1) 
  % Edge center 
  xgc = 0.5*(node(edge(:,1),1)+node(edge(:,2),1)); 
  ygc = 0.5*(node(edge(:,1),2)+node(edge(:,2),2)); 
end

%% Plotting 
figure(fwn);
fill(xx,yy,'w','LineWidth',3);
set(gca,'fontsize',18);
% H1 = patch(xx,yy,val);
%
% Showing nodal labels 
if ch0==1 
  for id=1:NumNds
    text(node(id,1)+0.0025, node(id,2)+0.015, ...
         ['\bf',num2str(id)],'fontsize',16);
  end
end
%
% Showing edge labels 
if ch1==1 
  for ig=1:NumEgs
    text(xgc(ig)-0.01, ygc(ig)+0.01, ...
         ['\color{red}',num2str(ig)],'fontsize',16);
  end
end
%
% Showing element labels 
if ch2==1 
  for ie=1:NumEms
    text(xec(ie),yec(ie),num2str(ie),'EdgeColor','blue','fontsize',16);
  end
end
%
% title('A small rectangular mesh');
% title(['\bf', 'Nodes: bold black;  Elements: blue box;  Edges: red']);
axis off;  axis tight;

return;
