function [] = show_QuadriMesh_ScaEmVecNd_mix(... 
  QuadriMesh,ScaEm,VecNd,fwn,ts,mf)
%% QuadriMesh: Show scalars in elements & vectors at nodes  
% as a mix of color image & quiver
% fwn: figure window number 
%  ts: title string for the figure window
%  mf: magnifying factor for vectors (length magnified mf times)  
% James Liu, ColoState; 2012/07--2020/08 

%% Mesh info 
node = QuadriMesh.node;
elem = QuadriMesh.elem;
% Assuming QuadriMesh.flag=3 

%% Preparing scalar ... 
xx = [node(elem(:,1),1)'; node(elem(:,2),1)';...
      node(elem(:,3),1)'; node(elem(:,4),1)'];
yy = [node(elem(:,1),2)'; node(elem(:,2),2)';...
      node(elem(:,3),2)'; node(elem(:,4),2)'];
scalar = repmat(ScaEm',4,1);

%% Plotting 
figure(fwn);
set(gca, 'fontsize', 18);
%
% For the scalar
H1 = patch(xx,yy,scalar); 
set(H1, 'edgecolor', 'interp'); 
colormap jet;
colorbar('location', 'eastoutside', 'fontsize',14);
%
% For the vector 
hold on;
quiver(QuadriMesh.node(:,1),  QuadriMesh.node(:,2), ...
  VecNd(:,1), VecNd(:,2), mf, 'k');  % Vectors are magnified mf times
%
% For the figure
title(ts);
axis equal;  axis tight;
% axis square;

return;