function [] = show_PlygnMesh_ScaEm_ClrImg(PlygnMesh,ScaEm,fwn,ts)
%% PlygnMesh: Show (emws.const.) scalar and vector 
% as a mix of color image & quiver
% fwn: figure window number 
%  ts: title string for the figure window
% James Liu, Zhuoran wang, ColoState; 2012/07--2018/09 

%% Mesh info 
% NumNds = PlygnMesh.NumNds;
NumEms = PlygnMesh.NumEms;
% NumEgs = PlygnMesh.NumEgs;
ElemType = PlygnMesh.ElemType;
node = PlygnMesh.node;
elem = PlygnMesh.elem;
% edge = PlygnMesh.edge;
% Assuming PlygnMesh.flag=3 

%% Plotting 
figure(fwn);
set(gca, 'fontsize', 18);
%
% For the scalar: Filling polygons 
for ie=1:NumEms
  xx = zeros(ElemType(ie),1);
  yy = zeros(ElemType(ie),1);
  for j=1:ElemType(ie)
    xx(j) = node(elem{ie}(j),1);
    yy(j) = node(elem{ie}(j),2);
  end
  fill(xx,yy,ScaEm(ie));
  hold on;
end
%
% For the figure
colorbar('location', 'eastoutside', 'fontsize', 14);
colormap jet;
title(ts);
axis equal;  axis tight;
% axis square;

return;