function [] = show_HybridMesh_labels(HybridMesh,fwn,ch0,ch1,ch2)
%% HybridMesh: Show node, element, edge labels in a specified window 
%  fwn: figure window number 
%  ch0: choice (0 or 1) for the nodes
%  ch1: choice (0 or 1) for the edges
%  ch2: choice (0 or 1) for the elements
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info
NumEms  = HybridMesh.NumEms;
NumEmsQ = HybridMesh.NumEmsQ;
NumEmsT = HybridMesh.NumEmsT;
node = HybridMesh.node;

%% Quadrilateral part 
elem = HybridMesh.elemQ;
% Arranging quadrilaterals 
xxQ = [node(elem(:,1),1)'; node(elem(:,2),1)';...
  node(elem(:,3),1)'; node(elem(:,4),1)'];
yyQ = [node(elem(:,1),2)'; node(elem(:,2),2)';...
  node(elem(:,3),2)'; node(elem(:,4),2)'];
valQ = repmat(zeros(1,NumEmsQ),4,1);

%% Triangular part 
elem = HybridMesh.elemT;
% Arranging quadrilaterals 
xxT = [node(elem(:,1),1)'; node(elem(:,2),1)'; node(elem(:,3),1)'];
yyT = [node(elem(:,1),2)'; node(elem(:,2),2)'; node(elem(:,3),2)'];
valT = repmat(zeros(1,NumEmsT),3,1);

%% Showing the mesh in a specified window 
figure(fwn);  % figure window number 
patch(xxQ,yyQ,valQ,'w');
patch(xxT,yyT,valT,'w');
title('A hybrid mesh');
axis equal;  
axis off;

% Showing nodal labels 
if ch0==1 
  for id=1:HybridMesh.NumNds
    % Showing nodal labels 
    text(node(id,1),node(id,2),['\bf',num2str(id)],'fontsize',16);
  end
end

% Showing edge labels 
if (ch1==1) 
  % Edge midpoints 
  xgc = 0.5*( HybridMesh.node(HybridMesh.edge(:,1),1)...
            + HybridMesh.node(HybridMesh.edge(:,2),1) ); 
  ygc = 0.5*( HybridMesh.node(HybridMesh.edge(:,1),2)...
            + HybridMesh.node(HybridMesh.edge(:,2),2)); 
  for ig=1:HybridMesh.NumEgs
    text(xgc(ig),ygc(ig),['\color{red}',num2str(ig)],'fontsize',16);
  end
end

% Showing element labels 
if ch2==1 
  for ie=1:HybridMesh.NumEms
    % JL20170207: TO BE FINISHED 
  end
end

title('A small hybrid mesh');
title(['\bf', 'Nodes: bold black;  Elements: blue box;  Edges: red']);
% axis equal;  
axis off;

return;