function [] = show_HybridMesh_ScaVecEm_mix(HybridMesh,ScaEm,VecEm,fwn,ts,mf)
%% HybridMesh: Show scalar+vector (emws.const.) as a mix of color image & quiver
% fwn: figure window number 
%  ts: title string for the figure window
%  mf: magnifying factor for vectors (length magnified mf times)  
% James Liu, Zhuoran Wang, ColoState; 2012/07--2017/02

%% Mesh info 
node = HybridMesh.node;
% Assuming HybridMesh.flag=3 

%% For the quadrilateral part 
elem = HybridMesh.elemQ;
% Preparing the scalar ... 
xxQ = [node(elem(:,1),1)'; node(elem(:,2),1)';...
  node(elem(:,3),1)'; node(elem(:,4),1)'];
yyQ = [node(elem(:,1),2)'; node(elem(:,2),2)';...
  node(elem(:,3),2)'; node(elem(:,4),2)'];
scalarQ = repmat(ScaEm(HybridMesh.labelemQ)',4,1);

%% For the triangular part 
elem = HybridMesh.elemT;
% Preparing the scalar ... 
xxT = [node(elem(:,1),1)'; node(elem(:,2),1)'; node(elem(:,3),1)'];
yyT = [node(elem(:,1),2)'; node(elem(:,2),2)'; node(elem(:,3),2)'];
scalarT = repmat(ScaEm(HybridMesh.labelemT)',3,1);

%% Plotting 
figure(fwn);
set(gca,'fontsize',18);
% For the scalar 
H1 = patch(xxQ,yyQ,scalarQ);
H2 = patch(xxT,yyT,scalarT);
set(H1,'edgecolor','interp'); 
colormap jet;
colorbar('location','eastoutside','fontsize',14);
hold on;
% For the vector 
quiver(HybridMesh.EmCntr(:,1), HybridMesh.EmCntr(:,2), ...
  VecEm(:,1),VecEm(:,2),mf,'k');  % vectors magnified mf times
% For the figure
title(ts);
axis equal;  axis tight;
% axis square;

return;