function [] = show_HybridMesh_ScaEm_ClrImg(HybridMesh,ScaEm,fwn,ts)
%% HybridMesh: Show scalar (elementwise constant) as a color image
% fwn: figure window number
%  ts: title string for the figure window
% James Liu, ColoState; 2012/07--2017/02

%% Mesh info 
node = HybridMesh.node;

%% For the quadrilateral part 
elem = HybridMesh.elemQ;
% Preparing the scalar ... 
xxQ = [node(elem(:,1),1)'; node(elem(:,2),1)';...
  node(elem(:,3),1)'; node(elem(:,4),1)'];
yyQ = [node(elem(:,1),2)'; node(elem(:,2),2)';...
  node(elem(:,3),2)'; node(elem(:,4),2)'];
scalarQ = repmat(ScaEm(HybridMesh.labelemQ)',4,1);

%% For the triangular part 
elem = HybridMesh.elemT;
% Preparing the scalar ... 
xxT = [node(elem(:,1),1)'; node(elem(:,2),1)'; node(elem(:,3),1)'];
yyT = [node(elem(:,1),2)'; node(elem(:,2),2)'; node(elem(:,3),2)'];
scalarT = repmat(ScaEm(HybridMesh.labelemT)',3,1);

%% Plotting 
figure(fwn);
set(gca,'fontsize',18);
% 
% For the scalar
H1 = patch(xxQ,yyQ,scalarQ);
H2 = patch(xxT,yyT,scalarT);
set(H1,'edgecolor','interp'); 
colormap jet;
colorbar('location','eastoutside','fontsize',14);
%
% For the figure
title(ts);
axis equal;  axis tight;
% axis square;

return;