function [] = show_HybridMesh(HybridMesh,fwn)
%% HybridMesh: Show the mesh in a specified figure window
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info
NumEms  = HybridMesh.NumEms;
NumEmsQ = HybridMesh.NumEmsQ;
NumEmsT = HybridMesh.NumEmsT;
node = HybridMesh.node;

%% Quadrilateral part 
elem = HybridMesh.elemQ;
% Arranging quadrilaterals 
xxQ = [node(elem(:,1),1)'; node(elem(:,2),1)';...
       node(elem(:,3),1)'; node(elem(:,4),1)'];
yyQ = [node(elem(:,1),2)'; node(elem(:,2),2)';...
       node(elem(:,3),2)'; node(elem(:,4),2)'];
valQ = repmat(zeros(1,NumEmsQ),4,1);

%% Triangular part 
elem = HybridMesh.elemT;
% Arranging quadrilaterals 
xxT = [node(elem(:,1),1)'; node(elem(:,2),1)'; node(elem(:,3),1)'];
yyT = [node(elem(:,1),2)'; node(elem(:,2),2)'; node(elem(:,3),2)'];
valT = repmat(zeros(1,NumEmsT),3,1);

%% Showing the mesh in a specified window 
figure(fwn);  % figure window number 
patch(xxQ,yyQ,valQ,'w');
patch(xxT,yyT,valT,'w');
% title('A hybrid mesh');
axis equal;  axis off;

return;