function varargout = DarcyLite_GUI(varargin)
% DARCYLITE_GUI MATLAB code for DarcyLite_GUI.fig
%      DARCYLITE_GUI, by itself, creates a new DARCYLITE_GUI or raises the existing
%      singleton*.
%
%      H = DARCYLITE_GUI returns the handle to a new DARCYLITE_GUI or the handle to
%      the existing singleton*.
%
%      DARCYLITE_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DARCYLITE_GUI.M with the given input arguments.
%
%      DARCYLITE_GUI('Property','Value',...) creates a new DARCYLITE_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before DarcyLite_GUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to DarcyLite_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help DarcyLite_GUI

% Last Modified by GUIDE v2.5 10-Jan-2016 18:09:52
% Farrah Sadre-Marandi, James Liu, ColoState; 2012/07--2018/12 

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @DarcyLite_GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @DarcyLite_GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before DarcyLite_GUI is made visible.
function DarcyLite_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to DarcyLite_GUI (see VARARGIN)

% Choose default command line output for DarcyLite_GUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes DarcyLite_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = DarcyLite_GUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


%% BEGIN PUSH BUTTON EXECUTION

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                               %
%     SHOW MESH                                                 %
%                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Executes on button press in ShowMesh.
function ShowMesh_Callback(hObject, eventdata, handles)
% hObject    handle to ShowMesh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%% Grab Input Data
  xa = str2num(get(handles.xa,'String'));
  xb = str2num(get(handles.xb,'String'));   
  yc = str2num(get(handles.yc,'String'));
  yd = str2num(get(handles.yd,'String'));
  nx = str2num(get(handles.nx,'String'));
  ny = str2num(get(handles.ny,'String'));
  MeshType = get(handles.MeshType,'Value');
 

%% Setting up the problem 
BndryDescMat = [xa,yc,xb,yc, 0,-1; ... 
                xb,yc,xb,yd, 1, 0; ... 
                xb,yd,xa,yd, 0, 1; ... 
                xa,yd,xa,yc,-1, 0];

%% Generating a uniform mesh on a given rectangular domain 

if (MeshType==1)  % RectMesh
    RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
    RectMesh = RectMesh_Enrich1(RectMesh);
    RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
    RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);
    show_RectMesh(RectMesh,11)

elseif (MeshType==2)  % TriMesh
    TriMesh = RectDom_TriMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
    TriMesh = TriMesh_Enrich1(TriMesh);
    TriMesh = TriMesh_Enrich2(TriMesh,BndryDescMat);
    TriMesh = TriMesh_Enrich3(TriMesh,BndryDescMat);
    show_TriMesh(TriMesh,11)
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                               %
%     RUN CODE                                                  %
%                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --- Executes on button press in RunCode.
function RunCode_Callback(hObject, eventdata, handles)
% hObject    handle to RunCode (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%% Grab Input Data
%   DomainType = get(handles.DomainType,'Value');  %(Rect==1, Lshaped==2)
  xa = str2num(get(handles.xa,'String'));
  xb = str2num(get(handles.xb,'String'));   
  yc = str2num(get(handles.yc,'String'));
  yd = str2num(get(handles.yd,'String'));

  PermFunc = get(handles.Permeability,'Value');
%   Fterm = get(handles.SourceTerm,'Value');  
  
  Dirichlet = get(handles.DirBC,'Value');
  Neumann = get(handles.NeumBC,'Value'); 
  
  MeshType = get(handles.MeshType,'Value');    
  nx = str2num(get(handles.nx,'String'));
  ny = str2num(get(handles.ny,'String'));
  
  NumericalMethod = get(handles.MethodType,'Value');

% Define Quadritures
  QLine = get(handles.LineQuad,'Value');
  if(QLine==1)
      QL=5;
  elseif(QLine==2)
      QL=1;
  elseif(QLine==3)
      QL=3;
  elseif(QLine==4)
      QL=5;
  elseif(QLine==5)
      QL=9;
  end
  QRect = get(handles.RectQuad,'Value');  
  if(QRect==1)
      QR=9;
  elseif(QRect==2)
      QR=1;
  elseif(QRect==3)
      QR=4;
  elseif(QRect==4)
      QR=9;
  elseif(QRect==5)
      QR=16;
  elseif(QRect==6)
      QR=25;
  end
  QTrig = get(handles.TriQuad,'Value');
    if(QTrig==1)
      QT=9;
  elseif(QTrig==2)
      QT=1;
  elseif(QTrig==3)
      QT=3;
  elseif(QTrig==4)
      QT=4;
  elseif(QTrig==5)
      QT=6;
  elseif(QTrig==6)
      QT=7;
  elseif(QTrig==7)
      QT=9;
  elseif(QTrig==8)
      QT=13;
  end


%% Setting up the problem (From Domain Type)
% It is automatically assumed we are on a rect domain

% if(DomainType==1)%Rect
%     % Not yet coded
% elseif(DomainType==2) %Lshaped
%     % Not yet coded
% end

%% Setting up the problem 
%(From Perm Type: this currently includes the f and BC for EXAMPLES)

BndryDescMat = [xa, yc, xb, yc, 0,-1; ...
                xb, yc, xb, yd, 1, 0; ... 
                xb, yd, xa, yd, 0, 1; ...
                xa, yd, xa, yc,-1, 0];

if (PermFunc==2)  % Order 2 identity matrix 
    EqnBC = EqnBC_Poisson_Ex11sinsin;
    BndryCondType = [0;1;1;1;1];
elseif (PermFunc==3)  % High-constrast permeability 
    EqnBC = EqnBC_Darcy_Ex13HetePerm;
    BndryCondType = [0;2;1;2;1];  
% elseif(PermFunc==4) %userinput
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% From Mesh Type: Rect
% Assembling and solving... (BY METHOD)

if (MeshType==1)  % RectMesh
  if (NumericalMethod==1) % CG
    disp('Generating & preparing a uniform rectangular mesh...');
    RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
    RectMesh = RectMesh_Enrich1(RectMesh);
    RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
    RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);

    %% Setting up quadratures 
    GAUSSQUAD = SetGaussQuad(5,25,9);

    %% Sampling the permeability 
    PermK = Darcy_SmplnPerm_RectMesh(EqnBC.fxnK, RectMesh, GAUSSQUAD);

    %% Sorting out boundary edges: Dirichlet, Neumann 
    DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
    NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

    %% Assembling and solving: CG_RectQ1 
    disp('CG.RectQ1: Assembling and solving...');
    tic;
    [sln] = Darcy_CG_RectQ1_AsmSlv( ... 
      EqnBC, RectMesh, PermK, DirichletEdge, NeumannEdge, GAUSSQUAD);
    toc

    %% Computing numer.pres.(emws.const.), vel.(em.cntr), flux discrepancy, LMCR
    % LMCR = local-mass-conservation-residual 
    [NumerPresEm,NumerVelEmCntr,NumerFlux,FluxDscp,LMCR]...
      = Darcy_CG_RectQ1_PresVelFlux(EqnBC,RectMesh,PermK,sln,GAUSSQUAD);

    msgbox('Success! CG on Rectangular Mesh Complete.')  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  elseif (NumericalMethod==2)  % DG  
    % Not yet coded! for Rect
    msgbox('Error! Please choose Triangular Mesh for DG method.')     

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  elseif (NumericalMethod==3)  % Weak Galerkin
    % disp('Discretization: Mesh generation and preparation...'); 
    RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
    RectMesh = RectMesh_Enrich1(RectMesh);
    RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
    RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);

    %% Setting up quadratures 
    GAUSSQUAD = SetGaussQuad(5,25,9);

    %% Sampling permeability 
    PermK = Darcy_SmplnPerm_RectMesh(EqnBC.fxnK,RectMesh,GAUSSQUAD);

    %% Sorting out boundary edges: Dirichlet, Neumann 
    DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
    NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

    %% WG: RectQ0Q0RT0: Assembling and solving 
    [sln] = Darcy_WG_RectQ0Q0RT0_AsmSlv( ... 
      EqnBC, BndryCondType, RectMesh, PermK, GAUSSQUAD);

    %% Computing numerical pressure, velocity, flux, etc. 
    [NumerPresEm, NumerVelCofRT0, NumerFlux, FluxDscp, LMCR] = ... 
      Darcy_WG_RectQ0Q0RT0_PresVelFlux(RectMesh, PermK, sln);
    NumerVelEmCntr = NumerVelCofRT0(:,1:2);
 
    msgbox('Success! Weak Galerkin on Rectangular Mesh Complete.')  

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    elseif (NumericalMethod==4)  % MFEM
    % disp('Discretization: mesh generation and preparation...'); 
    RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
    RectMesh = RectMesh_Enrich1(RectMesh);
    RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
    RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);

    %% Setting up quadratures 
    GAUSSQUAD = SetGaussQuad(5,25,9);

    %% Sampling permeability 
    PermKs = Darcy_SmplnPermSca_RectMesh(EqnBC.fxnKs, RectMesh, GAUSSQUAD);

    %% Sorting out boundary edges: Dirichlet, Neumann 
    DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
    NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

    %% Assembling and Solving... 
    % tic;
    [sln] = Darcy_MFEM_RectRT0Q0s_AsmSlv( ...
      EqnBC,BndryCondType,RectMesh,PermKs,GAUSSQUAD);
    % toc

    %% Computing numerical pressure, velocity, flux, etc. 
    [NumerPresEm, NumerVelEmCntr, NumerFlux, FluxDscp, LMCR] = ...
      Darcy_MFEM_RectRT0Q0_PresVelFlux(RectMesh, sln, BndryDescMat);

    msgbox('Success! MFEM on Rectangular Mesh Complete.')  
  end

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  elseif (MeshType==2)  % TriMesh
    if (NumericalMethod==1)  % CG
    % disp('Generating & preparing a uniform triangular mesh...');
    TriMesh = RectDom_TriMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
    TriMesh = TriMesh_Enrich1(TriMesh);
    TriMesh = TriMesh_Enrich2(TriMesh,BndryDescMat);
    TriMesh = TriMesh_Enrich3(TriMesh,BndryDescMat);

    %% Setting up quadratures 
    GAUSSQUAD = SetGaussQuad(5,25,9);

    %% Sampling the permeability 
    PermK = Darcy_SmplnPerm_TriMesh(EqnBC.fxnK, TriMesh, GAUSSQUAD);

    %% Sorting out boundary edges: Dirichlet, Neumann 
    DirichletEdge = find(BndryCondType(TriMesh.BndryEdge+1)==1);
    NeumannEdge   = find(BndryCondType(TriMesh.BndryEdge+1)==2);

    %% Assembling and solving: CG_TriP1 
    disp('CG.TriP1: Assembling and solving...');
    tic;
    [sln] = Darcy_CG_TriP1_AsmSlv(... 
      EqnBC, TriMesh, PermK, DirichletEdge, NeumannEdge, GAUSSQUAD);
    toc

    %% Computing numer.pres.(emws.const.), vel.(em.cntr), flux discrepancy, LMCR
    % LMCR = local-mass-conservation-residual 
    [NumerPresEm,NumerVelEmCntr,FluxDscp,LMCR]...
      = Darcy_CG_TriP1_PresVelFlux(EqnBC,TriMesh,PermK,sln,GAUSSQUAD);

    msgbox('Success! Continuous Galerkin on Triangular Mesh Complete.')   
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    elseif (NumericalMethod==2)  % DG    
      disp('Generating & preparing a uniform triangular mesh...');
      TriMesh = RectDom_TriMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
      TriMesh = TriMesh_Enrich1(TriMesh);
      TriMesh = TriMesh_Enrich2(TriMesh,BndryDescMat);
      TriMesh = TriMesh_Enrich3(TriMesh,BndryDescMat);

      %% Setting up quadratures 
      GAUSSQUAD = SetGaussQuad(5,25,9);

      %% Sampling the permeability 
      PermK = Darcy_SmplnPerm_TriMesh(EqnBC.fxnK,TriMesh,GAUSSQUAD);

      %% Sorting out boundary edges: Dirichlet, Neumann 
      DirichletEdge = find(BndryCondType(TriMesh.BndryEdge+1)==1);
      NeumannEdge   = find(BndryCondType(TriMesh.BndryEdge+1)==2);

      %% Assembling and solving: DG_TriP1 
      disp('DG_TriP1: Assembling and solving...');
      % beta=-1: SIPG;  beta=0: IIPG;  beta=1: NIPG  
      alpha = 4;  beta = -1;
      tic;
      [CofNS,GlbMat,GlbRHS] = Darcy_DG_TriP1_AsmSlv(EqnBC,...
        TriMesh,PermK,DirichletEdge,NeumannEdge,GAUSSQUAD,alpha,beta);
      toc

      %% Postprocessing 
      [PresAvgEm,NumerVelEmCntr,NumerFlux,NmlFlxEg,CofRT0]...
        = Darcy_DG_TriP1_PostProc(BndryDescMat,TriMesh,PermK,CofNS);

      msgbox('Success! Discontinuous Galerkin on Triangular Mesh Complete.') 
      
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    elseif(NumericalMethod==3)  % Weak Galerkin 
      disp('Generating & preparing a uniform triangular mesh...');
      TriMesh = RectDom_TriMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
      TriMesh = TriMesh_Enrich1(TriMesh);
      TriMesh = TriMesh_Enrich2(TriMesh,BndryDescMat);
      TriMesh = TriMesh_Enrich3(TriMesh,BndryDescMat);

      %% Setting up quadratures 
      GAUSSQUAD = SetGaussQuad(5,25,9);

      %% Sampling the permeability 
      PermK = Darcy_SmplnPerm_TriMesh(EqnBC.fxnK, TriMesh, GAUSSQUAD);

      %% Sorting out boundary edges: Dirichlet, Neumann 
      DirichletEdge = find(BndryCondType(TriMesh.BndryEdge+1)==1);
      NeumannEdge   = find(BndryCondType(TriMesh.BndryEdge+1)==2);

      %% Assembling and solving: WG(P0,P0,RT0) 
      disp('WG(P0,P0,RT0): Assembling and Solving...');
      tic;
      [sln] = Darcy_WG_TriP0P0RT0_AsmSlv( ...
        EqnBC, BndryCondType, TriMesh, PermK, GAUSSQUAD);
      toc

      %% Computing numerical pressure, velocity, flux, etc. 
      [NumerPresEm, NumerVelCofRT0, NumerFlux, FluxDscp, LMCR] = ... 
        Darcy_WG_TriP0P0RT0_PresVelFlux(TriMesh, PermK, sln);
      NumerVelEmCntr = NumerVelCofRT0(:,1:2);

      msgbox('Success! Weak Galerkin on Triangular Mesh Complete.')
      
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    elseif (NumericalMethod==4)  % MFEM 
      TriMesh = RectDom_TriMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
      TriMesh = TriMesh_Enrich1(TriMesh);
      TriMesh = TriMesh_Enrich2(TriMesh,BndryDescMat);
      TriMesh = TriMesh_Enrich3(TriMesh,BndryDescMat);

      %% Setting up quadratures 
      GAUSSQUAD = SetGaussQuad(5,25,9);

      %% Sampling the permeability 
      PermK = Darcy_SmplnPerm_TriMesh(EqnBC.fxnK, TriMesh, GAUSSQUAD);

      %% Sorting out boundary edges: Dirichlet, Neumann 
      DirichletEdge = find(BndryCondType(TriMesh.BndryEdge+1)==1);
      NeumannEdge   = find(BndryCondType(TriMesh.BndryEdge+1)==2);

      %% Assembling and solving... 
      tic;
      [sln] = Darcy_MFEM_TriRT0P0_AsmSlv( ...
        EqnBC, BndryCondType, TriMesh, PermK, GAUSSQUAD);
      toc

      %% Computing numerical pressure, velocity, flux 
      [NumerPresEm, NumerVelEmCntr, NumerFlux, FluxDscp, LMCR] = ...
        Darcy_MFEM_TriRT0P0_PresVelFlux(BndryDescMat, TriMesh, sln);

      msgbox('Success! MFEM on Triangular Mesh Complete.') 
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                               %
%     PLOT SOLN                                                 %
%                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --- Executes on button press in PlotSoln.
function PlotSoln_Callback(hObject, eventdata, handles)
% hObject    handle to RunCode (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%% Grab Input Data
%   DomainType = get(handles.DomainType,'Value');  %(Rect==1, Lshaped==2)
  xa = str2num(get(handles.xa,'String'));
  xb = str2num(get(handles.xb,'String'));   
  yc = str2num(get(handles.yc,'String'));
  yd = str2num(get(handles.yd,'String'));

  PermFunc = get(handles.Permeability,'Value');
%   Fterm = get(handles.SourceTerm,'Value');  
  
  Dirichlet = get(handles.DirBC,'Value');
  Neumann = get(handles.NeumBC,'Value'); 
  
  MeshType = get(handles.MeshType,'Value');    
  nx = str2num(get(handles.nx,'String'));
  ny = str2num(get(handles.ny,'String'));
  
  NumericalMethod = get(handles.MethodType,'Value');

% Define Quadritures
  QLine = get(handles.LineQuad,'Value');
  if(QLine==1)
      QL=5;
  elseif(QLine==2)
      QL=1;
  elseif(QLine==3)
      QL=3;
  elseif(QLine==4)
      QL=5;
  elseif(QLine==5)
      QL=9;
  end
  QRect = get(handles.RectQuad,'Value');  
  if(QRect==1)
      QR=9;
  elseif(QRect==2)
      QR=1;
  elseif(QRect==3)
      QR=4;
  elseif(QRect==4)
      QR=9;
  elseif(QRect==5)
      QR=16;
  elseif(QRect==6)
      QR=25;
  end
  QTrig = get(handles.TriQuad,'Value');
  if(QTrig==1)
      QT=9;
  elseif(QTrig==2)
      QT=1;
  elseif(QTrig==3)
      QT=3;
  elseif(QTrig==4)
      QT=4;
  elseif(QTrig==5)
      QT=6;
  elseif(QTrig==6)
      QT=7;
  elseif(QTrig==7)
      QT=9;
  elseif(QTrig==8)
      QT=13;
  end  

%% Setting up the problem (From Domain Type)
% It is automatically assumed we are on a rect domain

% if(DomainType==1)%Rect
%     % Not yet coded
% elseif(DomainType==2) %Lshaped
%     % Not yet coded
% end

%% Setting up the problem 
%(From Perm Type: this currently includes the f and BC for EXAMPLES)

BndryDescMat = [xa,yc,xb,yc, 0,-1; ... 
                xb,yc,xb,yd, 1, 0; ... 
                xb,yd,xa,yd, 0, 1; ... 
                xa,yd,xa,yc,-1, 0];

if (PermFunc==2)  % Constant
    EqnBC = EqnBC_Poisson_Ex11sinsin;
    BndryCondType = [0;1;1;1;1];
elseif (PermFunc==3)  % High-constrast
    EqnBC = EqnBC_Darcy_Ex13HetePerm;
    BndryCondType = [0;2;1;2;1];      
% elseif(PermFunc==4) %userinput
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% From Mesh Type: Rect
% Assembling and solving... (BY METHOD)

if (MeshType==1)  % RectMesh
if (NumericalMethod==1)  % CG

RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);

%% Setting up quadratures 
GAUSSQUAD = SetGaussQuad(5,25,9);

%% Sampling the permeability 
PermK = Darcy_SmplnPerm_RectMesh(EqnBC.fxnK, RectMesh, GAUSSQUAD);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

%% Assembling and solving: CG.RectQ1 
tic;
[sln] = Darcy_CG_RectQ1_AsmSlv( ... 
  EqnBC, RectMesh, PermK, DirichletEdge, NeumannEdge, GAUSSQUAD);
toc

%% Computing numer.pres.(emws.const.), vel.(em.cntr), flux discrepancy, LMCR
% LMCR = local-mass-conservation-residual 
[NumerPresEm,NumerVelEmCntr,NumerFlux,FluxDscp,LMCR]...
  = Darcy_CG_RectQ1_PresVelFlux(EqnBC,RectMesh,PermK,sln,GAUSSQUAD);

%% Presenting
show_RectMesh_ScaVecEm_mix(RectMesh, NumerPresEm, NumerVelEmCntr, ...
  23, 'CG.RectQ1: Numerical pressure and velocity', 1); 
show_scalar(FluxDscp, ... 
  24, 'CG.RectQ1: Flux discrepancy across edges');
show_RectMesh_ScaEm_ClrImg(RectMesh, LMCR, ...
  25, 'Local mass conservation residual');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif (NumericalMethod==2)  % DG  
    % Not yet coded! for Rect
msgbox('Error! Please choose Triangular Mesh for DG method.')     

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif (NumericalMethod==3)  % Weak Galerkin 
RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);

%% Setting up quadratures 
GAUSSQUAD = SetGaussQuad(5,25,9);

%% Sampling permeability 
PermK = Darcy_SmplnPerm_RectMesh(EqnBC.fxnK, RectMesh, GAUSSQUAD);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

%% WG: RectQ0Q0RT0: Assembling and Solving 
tic;
[sln] = Darcy_WG_RectQ0Q0RT0_AsmSlv( ...
  EqnBC, BndryCondType, RectMesh, PermK, GAUSSQUAD);
toc

%% Computing numerical pressure, velocity, flux, etc.
[NumerPresEm, NumerVelCofRT0, NumerFlux, FluxDscp, LMCR] = ... 
  Darcy_WG_RectQ0Q0RT0_PresVelFlux(RectMesh, PermK, sln);
NumerVelEmCntr = NumerVelCofRT0(:,1:2);

%% Presenting 
show_RectMesh_ScaVecEm_mix(RectMesh, NumerPresEm, NumerVelEmCntr, ...
  23, 'WG(Q0,Q0;RT[0]): Numeri. pressure & velocity', 1);  % Magnified 1x 
show_scalar(FluxDscp, ... 
  24, 'WG(Q0,Q0;RT[0]): Numeri. flux discrepancy across edges');
show_RectMesh_ScaEm_ClrImg(RectMesh, LMCR, ...
  25, 'WG(Q0,Q0;RT[0]): Local-mass-conservation residue');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif (NumericalMethod==4)  % MFEM
RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
RectMesh = RectMesh_Enrich1(RectMesh);
RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);

%% Setting up quadratures 
GAUSSQUAD = SetGaussQuad(5,25,9);

%% Sampling permeability 
PermKs = Darcy_SmplnPermSca_RectMesh(EqnBC.fxnKs, RectMesh, GAUSSQUAD);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

%% Assembling and Solving... 
tic;
[sln] = Darcy_MFEM_RectRT0Q0s_AsmSlv( ...
  EqnBC,BndryCondType,RectMesh,PermKs,GAUSSQUAD);
toc

%% Computing numerical pressure, velocity, flux, etc. 
[NumerPresEm, NumerVelEmCntr, NumerFlux, FluxDscp, LMCR] = ...
  Darcy_MFEM_RectRT0Q0_PresVelFlux(RectMesh, sln, BndryDescMat);

%% Presenting numerical & graphical results 
show_RectMesh_ScaVecEm_mix(RectMesh, NumerPresEm, NumerVelEmCntr, ...
  23, 'MFEM(RT[0],Q0): Numer. pressure & velocity', 2);  % Magnified 2X 
show_scalar(FluxDscp, ... 
  24, 'MFEM(RT[0],Q0): Numer. flux discrepancy across edges');
show_RectMesh_ScaEm_ClrImg(RectMesh, LMCR, ...
  25, 'MFEM(RT[0],Q0): Local-mass-conservation residue');

end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif(MeshType==2)  % TriMesh
if(NumericalMethod==1)  % CG
TriMesh = RectDom_TriMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
TriMesh = TriMesh_Enrich2(TriMesh,BndryDescMat);
TriMesh = TriMesh_Enrich3(TriMesh,BndryDescMat);

%% Setting up quadratures 
GAUSSQUAD = SetGaussQuad(5,25,9);

%% Sampling the permeability 
PermK = Darcy_SmplnPerm_TriMesh(EqnBC.fxnK, TriMesh, GAUSSQUAD);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(TriMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(TriMesh.BndryEdge+1)==2);

%% Assembling and Solving: CG.TriP1 
tic;
[sln] = Darcy_CG_TriP1_AsmSlv( ... 
  EqnBC, TriMesh, PermK, DirichletEdge, NeumannEdge, GAUSSQUAD);
toc

%% Computing numer.pres.(emws.const.), vel.(em.cntr), flux discrepancy, LMCR
% LMCR = local-mass-conservation-residual 
[NumerPresEm,NumerVelEmCntr,FluxDscp,LMCR]...
  = Darcy_CG_TriP1_PresVelFlux(EqnBC,TriMesh,PermK,sln,GAUSSQUAD);

%% Presenting
show_TriMesh_ScaNd_trisurf(TriMesh,sln, ... 
  21, 'CG.TriP1: Numerical pressure');
show_TriMesh_ScaVecEm_mix(TriMesh, NumerPresEm, NumerVelEmCntr, ...
  23, 'CG.TriP1: Numerical pressure and velocity', 1);
show_scalar(FluxDscp, ... 
  24, 'CG.TriP1: Flux discrepancy across edges');
show_TriMesh_ScaEm_ClrImg(TriMesh, LMCR, ...
  25, 'CG.TriP1: Local-mass-conservation residue');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif (NumericalMethod==2)  % DG    
TriMesh = RectDom_TriMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
TriMesh = TriMesh_Enrich2(TriMesh,BndryDescMat);
TriMesh = TriMesh_Enrich3(TriMesh,BndryDescMat);

%% Setting up quadratures 
GAUSSQUAD = SetGaussQuad(5,25,9);

%% Sampling the permeability 
PermK = Darcy_SmplnPerm_TriMesh(EqnBC.fxnK,TriMesh,GAUSSQUAD);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(TriMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(TriMesh.BndryEdge+1)==2);

%% Assembling and solving: DG_TriP1 
% beta=-1: SIPG;  beta=0: IIPG;  beta=1: NIPG  
alpha = 4;  beta = -1;
tic;
[CofNS,GlbMat,GlbRHS] = Darcy_DG_TriP1_AsmSlv(EqnBC,...
  TriMesh,PermK,DirichletEdge,NeumannEdge,GAUSSQUAD,alpha,beta);
toc

%% Postprocessing 
[PresAvgEm,NumerVelEmCntr,NumerFlux,NmlFlxEg,CofRT0]...
  = Darcy_DG_TriP1_PostProc(BndryDescMat,TriMesh,PermK,CofNS);

%% Presenting 
show_TriMesh_ScaVecEm_mix(TriMesh, PresAvgEm, NumerVelEmCntr, ...
  23, 'Numerical pressure and velocity', 2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif (NumericalMethod==3)  % WG 
TriMesh = RectDom_TriMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
TriMesh = TriMesh_Enrich2(TriMesh,BndryDescMat);
TriMesh = TriMesh_Enrich3(TriMesh,BndryDescMat);

%% Setting up quadratures 
GAUSSQUAD = SetGaussQuad(5,25,9);

%% Sampling the permeability 
PermK = Darcy_SmplnPerm_TriMesh(EqnBC.fxnK, TriMesh, GAUSSQUAD);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(TriMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(TriMesh.BndryEdge+1)==2);

%% Assembling and solving: WG(P0,P0,RT0) 
tic;
[sln] = Darcy_WG_TriP0P0RT0_AsmSlv( ...
  EqnBC, BndryCondType, TriMesh, PermK, GAUSSQUAD);
toc

%% Computing numerical pressure, velocity, flux, etc. 
[NumerPresEm,NumerVelEmCntr,NumerFlux,FluxDscp,LMCR] = ...
  Darcy_WG_TriP0P0RT0_PresVelFlux(TriMesh, PermK, sln);

%% Presenting numerical & graphical results
show_TriMesh_ScaVecEm_mix(TriMesh, NumerPresEm, NumerVelEmCntr, ...
  23, 'WG(P0,P0;RT0): Numerical pressure & velocity', 1);
show_scalar(FluxDscp, ...
  24, 'WG(P0,P0;RT0): Flux discrepancy across edges');
show_TriMesh_ScaEm_ClrImg(TriMesh, LMCR, ...
  25, 'WG(P0,P0;RT0): Local mass conservation residue');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif (NumericalMethod==4)  % MFEM
TriMesh = RectDom_TriMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
TriMesh = TriMesh_Enrich1(TriMesh);
TriMesh = TriMesh_Enrich2(TriMesh,BndryDescMat);
TriMesh = TriMesh_Enrich3(TriMesh,BndryDescMat);

%% Setting up quadratures 
GAUSSQUAD = SetGaussQuad(5,25,9);

%% Sampling the permeability 
PermK = Darcy_SmplnPerm_TriMesh(EqnBC.fxnK,TriMesh,GAUSSQUAD);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(TriMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(TriMesh.BndryEdge+1)==2);

%% Assembling and solving... 
tic;
[sln] = Darcy_MFEM_TriRT0P0_AsmSlv( ...
  EqnBC,BndryCondType,TriMesh,PermK,GAUSSQUAD);
toc

%% Computing numerical pressure, velocity, flux 
[NumerPresEm, NumerVelEmCntr, NumerFlux, FluxDscp, LMCR] = ...
  Darcy_MFEM_TriRT0P0_PresVelFlux(BndryDescMat, TriMesh, sln);

%% Presenting numerical & graphical results 
show_TriMesh_ScaVecEm_mix(TriMesh, NumerPresEm, NumerVelEmCntr, ...
  23, 'MFEM(RT0,P0): Numer. pressure & velocity', 1);
show_scalar(FluxDscp, ... 
  24, 'MFEM(RT0,P0): Nuemrical flux discrepancy across edges');
show_TriMesh_ScaEm_ClrImg(TriMesh, LMCR, ...
  25, 'MFEM(RT0,P0): Local mass conservation residue');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end
end


%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                               %
%     DO NOT EDIT - INPUTS                                      %
%                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% A
%%%%%%%%%%%%%%%%%
%                               
%   PICKING DOMAIN (Rect==1, Lshaped==2)
%                                                                                                                    
%%%%%%%%%%%%%%%%%

% --- Executes on selection change in DomainType.
function DomainType_Callback(hObject, eventdata, handles)
% hObject    handle to DomainType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
DomainType = get(handles.DomainType,'Value');  %(Rect==1, Lshaped==2)
if(DomainType==2) %Lshaped
    msgbox('Lshaped Domain Not Allowed')
end

% --- Executes during object creation, after setting all properties.
function DomainType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to DomainType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%%%%%%%%%%%%%%
%               %                                                     
%     xa        %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

function xa_Callback(hObject, eventdata, handles)
% hObject    handle to xa (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of xa as text
%        str2double(get(hObject,'String')) returns contents of xa as a double


% --- Executes during object creation, after setting all properties.
function xa_CreateFcn(hObject, eventdata, handles)
% hObject    handle to xa (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%%%%%%%%%%%%%%
%               %                                                     
%     xb        %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

function xb_Callback(hObject, eventdata, handles)
% hObject    handle to xb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of xb as text
%        str2double(get(hObject,'String')) returns contents of xb as a double


% --- Executes during object creation, after setting all properties.
function xb_CreateFcn(hObject, eventdata, handles)
% hObject    handle to xb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%%%%%%%%%%%%%%
%               %                                                     
%     yc        %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

function yc_Callback(hObject, eventdata, handles)
% hObject    handle to yc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of yc as text
%        str2double(get(hObject,'String')) returns contents of yc as a double


% --- Executes during object creation, after setting all properties.
function yc_CreateFcn(hObject, eventdata, handles)
% hObject    handle to yc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%%%%%%%%%%%%%%
%               %                                                     
%     yd        %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

function yd_Callback(hObject, eventdata, handles)
% hObject    handle to yd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of yd as text
%        str2double(get(hObject,'String')) returns contents of yd as a double


% --- Executes during object creation, after setting all properties.
function yd_CreateFcn(hObject, eventdata, handles)
% hObject    handle to yd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%% B
%%%%%%%%%%%%%%%%%
%                               
%   Input Permeability (Pick == 1, Constant==2, HighContrast==3, Random==4, UserInput==5)
%                                                                                                                    
%%%%%%%%%%%%%%%%%

% --- Executes on selection change in Permeability.
function Permeability_Callback(hObject, eventdata, handles)
% hObject    handle to Permeability (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
PermFunc = get(handles.Permeability,'Value');
 
if(PermFunc==2) 
%     EqnBC = EqnBC_Poisson_Ex11sinsin;

elseif(PermFunc==3) %HighConstrast
    PERMK = ones(20,20);
    PERMK(1,[1,4,5,10,11,16,18]) = 1e-6;
    PERMK(2,[5,9,10,11]) = 1e-6;
    PERMK(3,[6]) = 1e-6;
    PERMK(4,[10,16,20]) = 1e-6;
    PERMK(5,[7,12,19]) = 1e-6;
    PERMK(6,[4,8,14]) = 1e-6;
    PERMK(7,[9,14,15,18]) = 1e-6;
    PERMK(8,[18,19]) = 1e-6;
    PERMK(9,[1,3,8,9,10,13]) = 1e-6;
    PERMK(10,[10,12,18]) = 1e-6;
    PERMK(11,[1,11,16]) = 1e-6;
    PERMK(12,[5,7,8,10,20]) = 1e-6;
    PERMK(13,[3,6,7,8,11,15,19]) = 1e-6;
    PERMK(14,[1,3,6,8,9]) = 1e-6;
    PERMK(15,[10,16,17]) = 1e-6;
    PERMK(16,[2,3,6,7,12,19]) = 1e-6;
    PERMK(17,[2,3,8,15,19]) = 1e-6;
    PERMK(18,[5,19]) = 1e-6;
    PERMK(19,[10,11,14,18,20]) = 1e-6;
    PERMK(20,[12,14,16]) = 1e-6;
    figure(1)
    imagesc(PERMK);
    colorbar('location','eastoutside');
    
elseif(PermFunc==4) %User Input
msgbox('I am sorry. User input is not enabled.')
end


% --- Executes during object creation, after setting all properties.
function Permeability_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Permeability (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%%%%%%%%%%%%%%
%                               
%   Input Source Term (Pick == 1, SinCos==2, Hetero==3, UserInput==4)
%                                                                                                                    
%%%%%%%%%%%%%%%%%

% --- Executes on selection change in SourceTerm.
function SourceTerm_Callback(hObject, eventdata, handles)
% hObject    handle to SourceTerm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Fterm = get(handles.SourceTerm,'Value');
 
if(Fterm==4) %User Input
msgbox('I am sorry. User input is not enabled.')
end


% --- Executes during object creation, after setting all properties.
function SourceTerm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SourceTerm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%% C
%%%%%%%%%%%%%%%%%
%                               
%   Input BC
%                                                                                                                    
%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%
%               %                                                     
%   Neumann     %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%
% --- Executes on selection change in NeumBC.
function NeumBC_Callback(hObject, eventdata, handles)
% hObject    handle to NeumBC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Neumann = get(handles.NeumBC,'Value');
 
if(Neumann==4) %User Input
msgbox('I am sorry. User input is not enabled.')
end


% --- Executes during object creation, after setting all properties.
function NeumBC_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NeumBC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%%%%%%%%%%%%%%
%               %                                                     
%   Dirichlet   %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

% --- Executes on selection change in DirBC.
function DirBC_Callback(hObject, eventdata, handles)
% hObject    handle to DirBC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Dirichlet = get(handles.DirBC,'Value');
 
if(Dirichlet==4) %User Input
msgbox('I am sorry. User input is not enabled.')
end


% --- Executes during object creation, after setting all properties.
function DirBC_CreateFcn(hObject, eventdata, handles)
% hObject    handle to DirBC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%% D
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                               %
%     DEFINE MESH                                               %
%                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --- Executes on selection change in MeshType.
function MeshType_Callback(hObject, eventdata, handles)
% hObject    handle to MeshType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns MeshType contents as cell array
%        contents{get(hObject,'Value')} returns selected item from MeshType


% --- Executes during object creation, after setting all properties.
function MeshType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MeshType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%%%%%%%%%%%%%%
%               %                                                     
%     nx        %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

function nx_Callback(hObject, eventdata, handles)
% hObject    handle to nx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of nx as text
%        str2double(get(hObject,'String')) returns contents of nx as a double


% --- Executes during object creation, after setting all properties.
function nx_CreateFcn(hObject, eventdata, handles)
% hObject    handle to nx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%%%%%%%%%%%%%%%%%
%               %                                                     
%     ny        %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

function ny_Callback(hObject, eventdata, handles)
% hObject    handle to ny (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ny as text
%        str2double(get(hObject,'String')) returns contents of ny as a double


% --- Executes during object creation, after setting all properties.
function ny_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ny (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%% E
%%%%%%%%%%%%%%%%%
%               %                                                     
%     Line      %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

% --- Executes on selection change in LineQuad.
function LineQuad_Callback(hObject, eventdata, handles)
% hObject    handle to LineQuad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns LineQuad contents as cell array
%        contents{get(hObject,'Value')} returns selected item from LineQuad


% --- Executes during object creation, after setting all properties.
function LineQuad_CreateFcn(hObject, eventdata, handles)
% hObject    handle to LineQuad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%%%%%%%%%%%%%%
%               %                                                     
%     Rect      %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

% --- Executes on selection change in RectQuad.
function RectQuad_Callback(hObject, eventdata, handles)
% hObject    handle to RectQuad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns RectQuad contents as cell array
%        contents{get(hObject,'Value')} returns selected item from RectQuad


% --- Executes during object creation, after setting all properties.
function RectQuad_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RectQuad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%%%%%%%%%%%%%%
%               %                                                     
%     Tri       %                                                    
%               %                                                     
%%%%%%%%%%%%%%%%%

% --- Executes on selection change in TriQuad.
function TriQuad_Callback(hObject, eventdata, handles)
% hObject    handle to TriQuad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns TriQuad contents as cell array
%        contents{get(hObject,'Value')} returns selected item from TriQuad


% --- Executes during object creation, after setting all properties.
function TriQuad_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TriQuad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



%% II
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                               %
%     PICK METHOD                                               %
%                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Executes on selection change in MethodType.
function MethodType_Callback(hObject, eventdata, handles)
% hObject    handle to MethodType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns MethodType contents as cell array
%        contents{get(hObject,'Value')} returns selected item from MethodType


% --- Executes during object creation, after setting all properties.
function MethodType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MethodType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%% III
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                               %
%     PRESENTATION                                              %
%                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --- Executes on button press in PressVel.
function PressVel_Callback(hObject, eventdata, handles)
% hObject    handle to PressVel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of PressVel


% --- Executes on button press in LMCR.
function LMCR_Callback(hObject, eventdata, handles)
% hObject    handle to LMCR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of LMCR


% --- Executes on button press in Flux.
function Flux_Callback(hObject, eventdata, handles)
% hObject    handle to Flux (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Flux