function ProjSca = WG_TriP0P0RT0_ProjScaFxn1(TriMesh,GAUSSQUAD,ScaFxn,tm)
%% WG(P0,P0;RT0) rect.mesh: Projecting a time-dependent scalar fxn. to (P0,P0)
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info
NumEms = TriMesh.NumEms;
NumEgs = TriMesh.NumEgs;

%% Setting up 
% ProjSca.em = zeros(NumEms,1);
% ProjSca.eg = zeros(NumEgs,1);

%% Projecting the scalar function onto p.w.const. space over elements 
% i.e., computing averages (integrating) simultaneously across all elements
% using a Gaussian quadrature for triangles 
ProjSca.em = zeros(NumEms,1);
NumQuadPts = size(GAUSSQUAD.TRIG,1);
for k=1:NumQuadPts
  qp = GAUSSQUAD.TRIG(k,1) * TriMesh.node(TriMesh.elem(:,1),:)...
     + GAUSSQUAD.TRIG(k,2) * TriMesh.node(TriMesh.elem(:,2),:)...
     + GAUSSQUAD.TRIG(k,3) * TriMesh.node(TriMesh.elem(:,3),:);
  ProjSca.em = ProjSca.em + GAUSSQUAD.TRIG(k,4) * ScaFxn(qp,tm);  % */area
end

%% Projecting exact concentration onto p.w.const. space over edges 
% i.e., computing averages (integrating) simultaneously across all edges 
% using a Gaussian quadrature for line segments 
ProjSca.eg = zeros(NumEgs,1);
vrtx1 = TriMesh.node(TriMesh.edge(:,1),1:2);
vrtx2 = TriMesh.node(TriMesh.edge(:,2),1:2);
NumQuadPts = size(GAUSSQUAD.LINE,1);
for k=1:NumQuadPts
  qp = GAUSSQUAD.LINE(k,1)*vrtx1 + GAUSSQUAD.LINE(k,2)*vrtx2;
  ProjSca.eg = ProjSca.eg + GAUSSQUAD.LINE(k,3) * ScaFxn(qp,tm);
  % The edge len(gth) was actually cancelled in computation 
end

return;