function CofDWGsln = WG_TriP0P0RT0_CofRT0NmlzBas_DiscWkGradSln(TriMesh,sln)
%% Weak Galerkin on triangular mesh: Discrte weak gradient for a WG solution 
% Coeffs. in RT0 nmlz.bas. for this (global) solution 
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = TriMesh.NumEms;

%% Coeffs. in RT0 nmlz.bas. for disc.wk.grad. of 4 WG(Q0,Q0) bas.fxns. on tris.
CDWGB = WG_TriP0P0RT0_CofRT0NmlzBas_DiscWkGradBasFxn(TriMesh);

%% NOTE: Unusual index-matching 
CofDWGsln = zeros(NumEms,3);
for j=1:3  % The j-th RT0 bas.fxn.
  CofDWGsln(:,j) = CDWGB(:,1,j) .* sln(1:NumEms) ...
                 + CDWGB(:,2,j) .* sln(NumEms+TriMesh.elem2edge(:,1)) ...
                 + CDWGB(:,3,j) .* sln(NumEms+TriMesh.elem2edge(:,2)) ...
                 + CDWGB(:,4,j) .* sln(NumEms+TriMesh.elem2edge(:,3)) ;
end

return;