function ProjSca = WG_RectQ0Q0RT0_ProjScaFxn1(RectMesh,GAUSSQUAD,ScaFxn,tm)
%% WG(Q0,Q0;RT[0]) rect.mesh: Projecting a time-dependent scalar fxn. to (Q0,Q0)
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info
NumEms = RectMesh.NumEms;
NumEgs = RectMesh.NumEgs;

%% Setting up 
% ProjSca.em = zeros(NumEms,1);
% ProjSca.eg = zeros(NumEgs,1);

%% Projecting the scalar function onto p.w.const. space over elements
% i.e., computing averages (integrating) simultaneously across all elements
% using a Gaussian quadrature for rectangles 
NumQuadPts = size(GAUSSQUAD.RECT,1);
GAUSSQUADRECT1 = ones(NumQuadPts,2) - GAUSSQUAD.RECT(:,1:2);
x1 = RectMesh.node(RectMesh.elem(:,1),1);
y1 = RectMesh.node(RectMesh.elem(:,1),2);
x2 = RectMesh.node(RectMesh.elem(:,3),1);
y2 = RectMesh.node(RectMesh.elem(:,3),2);
ProjSca.em = zeros(NumEms,1);
qp = zeros(NumEms,2);
for k=1:NumQuadPts
  qp(:,1) = GAUSSQUAD.RECT(k,1)*x1 + GAUSSQUADRECT1(k,1)*x2;
  qp(:,2) = GAUSSQUAD.RECT(k,2)*y1 + GAUSSQUADRECT1(k,2)*y2;
  ProjSca.em = ProjSca.em + GAUSSQUAD.RECT(k,3) * ScaFxn(qp,tm);  % */area
end

%% Projecting the scalar function onto p.w.const. space over edges
% i.e., computing averages (integrating) simultaneously across all edges 
% using a Gaussian quadrature for line segments 
NumQuadPts = size(GAUSSQUAD.LINE,1);
vrtx1 = RectMesh.node(RectMesh.edge(:,1),1:2);
vrtx2 = RectMesh.node(RectMesh.edge(:,2),1:2);
ProjSca.eg = zeros(NumEgs,1);
for k=1:NumQuadPts
  qp = GAUSSQUAD.LINE(k,1)*vrtx1 + GAUSSQUAD.LINE(k,2)*vrtx2;
  ProjSca.eg = ProjSca.eg + GAUSSQUAD.LINE(k,3) * ScaFxn(qp,tm);
  % The edge len(gth) was actually cancelled in computation 
end

return;