function CofDWGsln = WG_RectQ0Q0RT0_CofRT0NmlzBas_DiscWkGradSln(RectMesh,sln)
%% Weak Galerkin on rectangular mesh: Discrte weak gradient for a WG solution 
% Coeffs. in RT[0] nmlz.bas. for this (global) solution 
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = RectMesh.NumEms;

%% Coeffs. in RT[0] nmlz.bas. for disc.wk.grad. of 5 WG(Q0,Q0) bas.fxns. on rect.
CDWGB = WG_RectQ0Q0RT0_CofRT0NmlzBas_DiscWkGradBasFxn(RectMesh);

%% NOTE: Unusal index-matching 
CofDWGsln = zeros(NumEms,4);
for j=1:4  % The j-th RT[0] bas.fxn.
  CofDWGsln(:,j) = CDWGB(:,1,j) .* sln(1:NumEms) ...
                 + CDWGB(:,2,j) .* sln(NumEms+RectMesh.elem2edge(:,1)) ...
                 + CDWGB(:,3,j) .* sln(NumEms+RectMesh.elem2edge(:,2)) ...
                 + CDWGB(:,4,j) .* sln(NumEms+RectMesh.elem2edge(:,3)) ...
                 + CDWGB(:,5,j) .* sln(NumEms+RectMesh.elem2edge(:,4)) ;
end

return;