function CDWGB = WG_RectQ0Q0RT0_CofRT0NmlzBas_DiscWkGradBasFxn(RectMesh) 
%% Weak Galerkin on rect.mesh: Discrte weak gradients for (Q0,Q0) bas.fxns.
% Cofs. RT[0] nmlz.bas. for disc.wk.grad. of 5 WG(Q0,Q0) bas.fxns. on rectangles
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = RectMesh.NumEms;
x1 = RectMesh.node(RectMesh.elem(:,1),1);
y1 = RectMesh.node(RectMesh.elem(:,1),2);
x2 = RectMesh.node(RectMesh.elem(:,3),1);
y2 = RectMesh.node(RectMesh.elem(:,3),2);
Deltax = x2 - x1;
Deltay = y2 - y1;

%% Computing the coefficients 
% All elements, 5 WG0 bas.fxns., 4 RT[0] bas.fxns.
CDWGB = zeros(NumEms,5,4);  
ZO = zeros(NumEms,1);
% For the 1 WG element interior basis functions 
CDWGB(:,1,:) = [ZO, ZO, -12./(Deltax.^2), -12./(Deltay.^2)];
% For the 4 WG edge basis functions 
CDWGB(:,2,:) = [ZO, -1./Deltay, ZO, 6./(Deltay.^2)];
CDWGB(:,4,:) = [ZO,  1./Deltay, ZO, 6./(Deltay.^2)];
CDWGB(:,3,:) = [ 1./Deltax, ZO, 6./(Deltax.^2), ZO]; 
CDWGB(:,5,:) = [-1./Deltax, ZO, 6./(Deltax.^2), ZO];

return;