function CDWGB = WG_PlygnP0P0CW0_Wachspress_DiscWkGradBasFxn( ...
  PlygnMesh,GAUSSQUAD)
%% WG(P0,P0;CW0)Plygn: 
% James Liu, ColoState; 2012/07--2017/08 

%% Mesh info 
NumEms = PlygnMesh.NumEms;

%% Edge length info needed 
LenEg = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  LenEg{ie} = zeros(n,1);
  for m=1:n
    m1 = mod(m,n) + 1;
    tmpx = PlygnMesh.node(PlygnMesh.elem{ie}(m1),1) ...
         - PlygnMesh.node(PlygnMesh.elem{ie}(m),1);
    tmpy = PlygnMesh.node(PlygnMesh.elem{ie}(m1),2) ...
         - PlygnMesh.node(PlygnMesh.elem{ie}(m),2);
    LenEg{ie}(m) = sqrt(tmpx^2+tmpy^2);
  end
end

%% 
RHS = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  RHS{ie} = zeros(n+1,n);
  for m=1:n
    RHS{ie}(1,m)   = -LenEg{ie}(m);
    RHS{ie}(m+1,m) =  LenEg{ie}(m);
  end
end

%% Hdiv: CW0: Gram matrix 
GM = Hdiv_PlygnCW0_Wachspress_GramMat(PlygnMesh,GAUSSQUAD);

%% 
CDWGB = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  CDWGB{ie} = zeros(n+1,n);
  EltGM = GM{ie};
  for m=1:(n+1)
    EltRHS = RHS{ie}(m,:);
    CDWGB{ie}(m,:) = EltGM\EltRHS';
  end
end

return;