function EqnBIC = EqnBIC_TransCD_Ex22RotGauss
%% EqnBIC: Trans.CD: A clockwise rotating Gaussian "plume" w/ no source
% Example 2.2 on (0,1)^2;  Rot. around dom. center;  Allowing no-diffusion
% James Liu, ColoState; 2012/07--2017/02 

% These parameters can be adjusted 
T = pi/8;  % Time period [0,T], 2*pi for a complete rotation 
D = 1e-9;  % Diffusion coefficient 
xc = 0.25;  yc = 0.75;  % Center of the initial "plume" 
sigma22 = 0.004;  % 2*sigma^2: Size of the initial "plume" 

EqnBIC = struct('T',T, ...
  'fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, 'fxnc0',@fxnc0, ...
  'fxnc',@fxnc);
  % 'fxnExactChara',@fxnExactChara);

% Known velocity field 
function v = fxnv(pt)
  x = pt(:,1);  y = pt(:,2);
  v = [y-0.5, -(x-0.5)];
end

% The right-hand function in the PDE 
function f = fxnf(pt,t)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition for the concentration 
function  cD = fxncD(pt,t)
  x = pt(:,1);  % y = pt(:,2);
  % cD = fxnc(pt,t);
  cD = zeros(size(x));
end

% Neumann boundary condition for the concentration 
% --None 

% Known initial concentration 
function c0 = fxnc0(pt)
  x = pt(:,1);  y = pt(:,2);
  tmp = (x-xc).^2 + (y-yc).^2;
  c0 = exp(-tmp/sigma22);
end

% Known exact concentration 
function c = fxnc(pt,t)
  x = pt(:,1);  y = pt(:,2);
  X = 2*(x-0.5);  Y = 2*(y-0.5);
  Xstar = cos(t)*X - sin(t)*Y;
  Ystar = sin(t)*X + cos(t)*Y;
  xstar = 0.5 * (Xstar+1);
  ystar = 0.5 * (Ystar+1);
  tmp = (xstar-xc).^2 + (ystar-yc).^2;
  c = sqrt(sigma22/(sigma22+4*D*t)) * exp(-tmp/(sigma22+4*D*t));
end

end