function EqnBIC = EqnBIC_TransCD_Ex21RotGauss
%% EqnBIC: Trans.CD: A clockwise rotating Gaussian "plume" w/ no source
% Example 2.1 on [0,1]^2;  Rot. around lower-left cnr.;  Allowing no-diff.
% James Liu, ColoState; 2012/07--2017/02

% These parameters can be adjusted 
T = pi/4;  % Time period [0,T] 
D = 1e-3;  % Diffusion coefficient 
xc = 0.25;  yc = 0.75;  % Center of the initial "plume" 
sigma22 = 0.004;  % 2*sigma^2: Size of the initial "plume" 

EqnBIC = struct('T',T, ...
  'fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, 'fxnc0',@fxnc0, ...
  'fxnc',@fxnc, ...
  'fxnExactChara',@fxnExactChara);

% Known velocity field 
function v = fxnv(pt) 
  x = pt(:,1);  y = pt(:,2);
  v = [y, -x];
end

% The right-hand function in the PDE 
function f = fxnf(pt,t)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition for the concentration 
function cD = fxncD(pt,t) 
  % x = pt(:,1);  y = pt(:,2);
  cD = fxnc(pt,t);
end

% Neumann boundary condition for the concentration 
% --None 

% Known initial concentration 
function c0 = fxnc0(pt)
  x = pt(:,1);  y = pt(:,2);
  tmp = (x-xc).^2 + (y-yc).^2;
  c0 = exp(-tmp/sigma22);
end

% Known exact concentration 
function c = fxnc(pt,t)
  x = pt(:,1);  y = pt(:,2);
  xstar = cos(t)*x - sin(t)*y;
  ystar = sin(t)*x + cos(t)*y;
  tmp = (xstar-xc).^2 + (ystar-yc).^2;
  c = sqrt(sigma22/(sigma22+4*D*t)) * exp(-tmp/(sigma22+4*D*t));
end

% Known exact characteristics (backward, true for forward also)
% from head (x,y,t1) backward to foot (xstar,ystar,t0) 
function qt = fxnExactChara(pt,t1,t0)
  x = pt(:,1);  y = pt(:,2);  dt = t1 - t0;
  xstar = cos(dt)*x - sin(dt)*y;
  ystar = sin(dt)*x + cos(dt)*y;
  qt = [xstar,ystar];
end

end