function EqnBIC = EqnBIC_TransCD_Ex20MovingGauss
%% EqnBIC: Trans.CD: A moving Gaussian "plume" w/ no source
% Example 2.0 on [0,1]^2;  Allowing no-diff.
% James Liu, ColoState; 2012/07--2017/02 

% These parameters can be adjusted 
T = 0.5;  % Time period [0,T]
D = 1e-3;  % Diffusion coefficient
xc = 0.30;  yc = 0.30;  % Center of the initial "plume"
sigma22 = 0.004;  % 2*sigma^2: Size of the initial "plume" 

EqnBIC = struct('T',T, ...
  'fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, 'fxnc0',@fxnc0, ...
  'fxnc',@fxnc);

% No known velocity field, so set to zero 
function v = fxnv(pt) 
  % x = pt(:,1);  y = pt(:,2);
  v = zeros(size(pt));
end

% The right-hand function in the PDE 
function f = fxnf(pt,t)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition for the concentration 
function cD = fxncD(pt,t) 
  x = pt(:,1);  % y = pt(:,2);
  cD = zeros(size(x));
end

% Neumann boundary condition for the concentration 
% --None 

% Known initial concentration 
function c0 = fxnc0(pt)
  x = pt(:,1);  y = pt(:,2);
  tmp = (x-xc).^2 + (y-yc).^2;
  c0 = exp(-tmp/sigma22);
end

% No known exact concentration, so set to zero 
function c = fxnc(pt,t)
  x = pt(:,1);  % y = pt(:,2);
  c = zeros(size(x));
end

end