function EqnBIC = EqnBIC_TransCD_Ex11MovingGauss
%% EqnBIC: Trans.conv.-diff.: A moving Gaussian plume, Const.vel. & source
% Example 1.1 on [0,1]^2;  Concentration max.1;  Allowing no-diffusion
% James Liu, ColoState; 2012/07--2017/02 

% These parameters can be adjusted
T = 0.2;  % Time period [0,T]
D = 1e-2;  % Diffusion coefficient 
a = 1;  b = 0;  % Velocity vector v=[a,b]
xc = 0.40;  yc = 0.40;  % Center of the initial "plume"
sigma22 = 0.02;  % 2*sigma^2: Size of the initial "plume"

EqnBIC = struct('T',T, ...
  'fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, 'fxnc0',@fxnc0, ...
  'fxnc',@fxnc, ...
  'fxnBkwdChara',@fxnExactChara);

% Known velocity field 
function v = fxnv(pt) 
  x = pt(:,1);  % y = pt(:,2);
  v = [a*ones(size(x)), b*ones(size(x))];
end

% The right-hand function in the PDE: Source
function f = fxnf(pt,t)
  x = pt(:,1);  y = pt(:,2);
  tmp = (x-a*t-xc).^2 + (y-b*t-yc).^2;
  c = exp(-tmp/sigma22);
  f = 2*D/sigma22 * (2-2*tmp/sigma22) .* c;
end

% Dirichlet boundary condition for the concentration 
function cD = fxncD(pt,t) 
  % x = pt(:,1);  % y = pt(:,2);
  % cD = zeros(size(x));
  cD = fxnc(pt,t);
end

% Neumann boundary condition for the concentration 
% --None 

% Known initial concentration
function c0 = fxnc0(pt)
  x = pt(:,1);  y = pt(:,2);
  tmp = (x-xc).^2 + (y-yc).^2;
  c0 = exp(-tmp/sigma22);
end

% Known exact concentration 
function c = fxnc(pt,t)
  x = pt(:,1);  y = pt(:,2);
  tmp = (x-a*t-xc).^2 + (y-b*t-yc).^2;
  c = exp(-tmp/sigma22);
end

% Known exact characteristics (backward, true for forward also)
% from head (x,y,t1) backward to foot (xstar,ystar,tnew,t0)
function qt = fxnExactChara(pt,t1,t0)
  x = pt(:,1);  y = pt(:,2);  dt = t1 - t0;
  xstar = x - a * dt;
  ystar = y - b * dt;
  qt = [xstar,ystar];
end

end