function EqnBIC = EqnBIC_TransCD_Ex10MovingPlume
%% EqnBIC: Trans.CD: A moving "plume" w/ no source
% Example 1.0 on [0,1]^2;  Allowing no-diff.
% James Liu, ColoState; 2012/07--2017/02 

% These parameters can be adjusted 
T = 0.5;  % Time period [0,T]
D = 1e-3;  % Diffusion coefficient
% a = 0.1;  b = 0.2;  c = 0.3;  d = 0.7;  % Initial rectangular "plume"
a = 0.1;  b = 0.2;  c = 0.3;  d = 0.7;  % Initial rectangular "plume"

EqnBIC = struct('T',T, ...
  'fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, 'fxnc0',@fxnc0, ...
  'fxnc',@fxnc);

% No known velocity field, so set to zero 
function v = fxnv(pt) 
  % x = pt(:,1);  y = pt(:,2);
  v = zeros(size(pt));
end

% The right-hand function in the PDE 
function f = fxnf(pt,t)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition for the concentration 
function cD = fxncD(pt,t) 
  x = pt(:,1);  % y = pt(:,2);
  cD = zeros(size(x));
end

% Neumann boundary condition for the concentration 
% --None 

% Known initial concentration 
function c0 = fxnc0(pt)
  x = pt(:,1);  y = pt(:,2);
  c0 = zeros(size(x));
  k = find(a<=x & x<=b & c<=y & y<=d);
  c0(k) = 1;
end

% No known exact concentration, so set to zero 
function c = fxnc(pt,t)
  x = pt(:,1);  % y = pt(:,2);
  c = zeros(size(x));
end

end