function EqnBIC = EqnBIC_Parab_Ex11eatsinsin
%% EqnBIC: Parabolic eqn.: c(x,y,t) = e^{at} sin(\pi x) sin(\pi y) 
% Example 1.1 on the unit square with 
%  -- homogeneous Dirichlet bndry. cond. 
%  -- initial condition sin(\pi x) sin(\pi y) 
% James Liu, ColoState; 2012/07--2017/02 

% These parameters can be adjusted 
T = 1;  % Time period [0,T] 
D = 1;  % Diffusion coefficient 
a = -0.5;  % Decay rate 

EqnBIC = struct('T',T, ...
  'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxnc0',@fxnc0, ...
  'fxnc',@fxnc);

% The right-hand side function in the parabolic equation
function  f = fxnf(pt,t)
  x = pt(:,1);  y = pt(:,2);
  f = (a+D*2*(pi*pi)) * exp(a*t) * sin(pi*x).*sin(pi*y);
end

% Dirichlet boundary conditions
function  cD = fxncD(pt,t) 
  % x = pt(:,1);  y = pt(:,2);
  cD = zeros(size(pt,1),1);
end

% Neumann boundary condition
% None 

% Initial concentration 
function  c0 = fxnc0(pt)
  x = pt(:,1);  y = pt(:,2);
  c0 = sin(pi*x).*sin(pi*y);
end 

% Known exact "concentration" 
function  c = fxnc(pt,t)
  x = pt(:,1);  y = pt(:,2);
  c = exp(a*t) * sin(pi*x).*sin(pi*y);
end

end