function EqnBC = EqnBC_StokesDarcy3domH_GrahamExVar_Part2Darcy 
%% Part2 Darcy (0,1)x(0,1) 
% A variant of the example designed by Graham 
% James Liu, Graham Harper, ColoState; 2019/07--2020/09 

%% Parameter 
kappa = 1;  % Choices: 1, 1e-3, 1e-6

EqnBC = struct('kappa',kappa, ...
  'fxnK',@fxnK, 'fxns',@fxns, 'fxng',@fxng, ...
  'fxnpD',@fxnpD, 'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnu',@fxnu);

%% Darcy: Permeability as an elem.const. 2x2 SPD matrix: kappa*[1,0;0,1] 
function K = fxnK(pt) 
  x = pt(:,1);  % y = pt(:,2);
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = kappa * ones(size(x));
  K(:,2,2) = kappa * ones(size(x));
end

%% Darcy: Source term 
function s = fxns(pt)
  x = pt(:,1);
  s = zeros(size(x));
end

%% Darcy: Additional term 
function g = fxng(pt)
  g = zeros(size(pt));
end

%% Darcy: Dirichlet boundary conditions 
function pD = fxnpD(pt)
  pD = fxnp(pt);
end

%% Darcy: Neumann boundary conditions 
function uN = fxnuN(pt)
  x = pt(:,1);
  uN = zeros(size(x));
end

%% Darcy: Known exact solution for pressure 
function p = fxnp(pt)
  x = pt(:,1);
  p = zeros(size(x));
end

%% Darcy: Known exact solution for velocity 
function u = fxnu(pt)
  x = pt(:,1);
  u1 = zeros(size(x));
  u2 = zeros(size(x));
  u = [u1, u2];
end

end