function EqnBC = EqnBC_StokesDarcy3domH_GrahamExVar_Part1Stokes 
%% Stokes (-1,0)x(0,1) 
% A variant of the example designed by Graham 
% James Liu, Graham Harper, ColoState; 2019/07--2020/08 

%% Parameters 
nu = 1;  % For Stokes 

EqnBC = struct('nu',nu, 'fxnf',@fxnf, ...
  'fxnuD',@fxnuD, 'fxntN',@fxntN, ...
  'fxnu',@fxnu, 'fxnp',@fxnp);

%% Stokes: Body force: Zero  
function f = fxnf(pt)
  f = zeros(size(pt));
end

%% Stokes: Dirichlet boundary conditions for y=0 or y=1 or x=-1 
function uD = fxnuD(pt)
  x = pt(:,1);  y = pt(:,2);
  uD = zeros(size(pt));
  uD(:,1) = 4*y.*(1-y);
end

%% Stokes: Neumann or traction boundary conditions 
function tN = fxntN(pt)
  x = pt(:,1);
  tN1 = zeros(size(x));
  tN2 = zeros(size(x));
  tN = [tN1, tN2];  
end

%% Stokes: Exact solution for velocity (JL: Still parabolic profile??) 
function u = fxnu(pt)
  x = pt(:,1);  y = pt(:,2);
  u1 = 4 * y .* (1-y);
  u2 = zeros(size(x));
  u = [u1, u2];
end

%% Stokes: Exact solution for pressure unknown, so set to 0 
function p = fxnp(pt)
  x = pt(:,1);
  p = zeros(size(x));
end

end