function EqnBC = EqnBC_SteadyCD_Ex24RotVelBndryIntrLayers
%% EqnBC: Steady convection-diffusion equation
% Domain [0,1]^2;  Rotating vel.(y,-x);  Bndry.layer @y=0, intr.layer rotating
% Adopted from deFrutos3_CMAME_2014 (p.232 Ex.5 remark)
% James Liu, ColoState; 2012/07--2017/02

D = 1e-3;  % Diffusion coefficient

EqnBC = struct('fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, ...
  'fxnc',@fxnc);

% Known velocity field
function v = fxnv(pt) 
  x = pt(:,1);  y = pt(:,2);
  v = [y, -x];
end

% The right-hand function in the PDE
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition for the concentration 
function cD = fxncD(pt) 
  x = pt(:,1);  % y = pt(:,2);
  cD = zeros(size(x));  % All other 3 sides: zero
  k = find(x==0);  cD(k) = 1;  % Left side: Inflow/entrance
end

% Neumann boundary condition for the concentration 
% --None 

% ? No known exact concentration, so set to 0
function c = fxnc(pt)
  x = pt(:,1);  % y = pt(:,2);
  c = zeros(size(x));
end

end