function EqnBC = EqnBC_SteadyCD_Ex23RotVelBndryLayer
%% EqnBC: Steady convection-diffusion equation
% Domain [0,1]^2;  Rotating velocity (-y,x);  Bndry.layer at y=1
% Adopted from XuZik_MCOM_1999 (p.1442 Ex.1)
% James Liu, ColoState; 2012/07--2017/02 

D = 1e-2;  % Diffusion coefficient

EqnBC = struct('fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, ...
  'fxnc',@fxnc);

% Known velocity field 
function v = fxnv(pt) 
  x = pt(:,1);  y = pt(:,2);
  v = [-y, x];
end

% The right-hand function 
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = ones(size(x));
end

% Dirichlet boundary condition for the concentration 
function cD = fxncD(pt) 
  x = pt(:,1);  % y = pt(:,2);
  cD = zeros(size(x));
end

% Neumann boundary condition for the concentration 
% --None 

% ? No known exact concentration, so set to 0
function c = fxnc(pt)
  x = pt(:,1);  % y = pt(:,2);
  c = zeros(size(x));
end

end