function EqnBC = EqnBC_SteadyCD_Ex22ConstVelBndryIntrLayers
%% EqnBC: Steady conv.-diff.: Const. velocity, Bndry. & interior layers
% Domain [0,1]^2;  Const.vel.(3,-1);  Bndry.layer x=1;  Intr.layer:x+3y=2
% Adopted from ManziRusso_CMAME_2008 (p.1256 Ex.5.2.3)
% James Liu, ColoState; 2012/07--2017/02 

D = 1e-3;  % Diffusion coefficient

EqnBC = struct('fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, ...
  'fxnc',@fxnc);

% Known velocity field v=(3,-1)
function v = fxnv(pt) 
  x = pt(:,1);  % y = pt(:,2);
  v = [3*ones(size(x)), -ones(size(x))];
end

% The right-hand function 
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition for the concentration 
function cD = fxncD(pt) 
  x = pt(:,1);  y = pt(:,2);
  cD = zeros(size(x));
  k = find(x==0 & y>(2/3));  cD(k) = 1;
  k = find(x>0 & x<1 & y==1);  cD(k) = 1;
end

% Neumann boundary condition for the concentration 
% --None 

% ? No known exact concentration, so set to 0
function c = fxnc(pt)
  x = pt(:,1);  % y = pt(:,2);
  c = zeros(size(x));
end

end