function EqnBC = EqnBC_SteadyCD_Ex21ConstVelBndryLayers
%% EqnBC: Steady conv.-diff.: Const. velocity, Chara.bndry.layers 
% Domain [0,1]^2;  Const. velocity (1,0);  Bndry.layers at y=0 & y=1 
% Adopted from M.Stynes
% James Liu, ColoState; 2012/07--2017/02 

D = 1e-3;  % Diffusion coefficient

EqnBC = struct('fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, ...
  'fxnc',@fxnc);

% Known velocity field v=(1,0)
function v = fxnv(pt) 
  x = pt(:,1);  % y = pt(:,2);
  v = [ones(size(x)), zeros(size(x))];
end

% The right-hand function 
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = ones(size(x));
end

% Dirichlet boundary condition for the concentration 
function cD = fxncD(pt) 
  x = pt(:,1);  % y = pt(:,2);
  cD = zeros(size(x));
end

% Neumann boundary condition for the concentration 
% --None 

% ? No known exact concentration, so set to 0
function c = fxnc(pt)
  x = pt(:,1);  % y = pt(:,2);
  c = zeros(size(x));
  % For x: c = x - (exp(x/D)-1)/(exp(1/D)-1);
  % For y: ?
end

end