function EqnBC = EqnBC_SteadyCD_Ex11ConstVelBndryLayer
%% EqnBC: Steady-state convection-diffusion equation 
% Domain [0,1]^2;  Constant velocity (1,0);  Boundary layer at x=1 
% James Liu, ColoState; 2012/07--2017/02 

D = 1e-1;  % Diffusion coefficient

EqnBC = struct('fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, ...
  'fxnc',@fxnc, 'fxncg',@fxncg);

% Known velocity field 
function v = fxnv(pt) 
  x = pt(:,1);  % y = pt(:,2);
  v = [ones(size(x)), zeros(size(x))];
end

% The right-hand function 
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition for the concentration
function cD = fxncD(pt) 
  x = pt(:,1);  % y = pt(:,2);
  cD = fxnc(pt);
end

% Neumann boundary condition for the concentration 
% --None 

% Known exact concentration
function c = fxnc(pt)
x = pt(:,1);  y = pt(:,2);
c = (1-exp((x-1)/D))/(1-exp(-1/D)) .* y;
end

% JL20151027: TO BE REVISED LATER, NOW TEMPORARILY SET TO 0
% Known exact concentration gradient 
function cg = fxncg(pt)
  x = pt(:,1);  % y = pt(:,2);
  % cg = [cx,cy];
  cg = zeros(size(pt));
end

end