function EqnBC = EqnBC_SteadyCD_Ex10sinsin
%% EqnBC: Steady-state conv.-diff. eqn.: Known sln. sin(pi*x)sin(pi*y) 
% Domain [0,1]^2;  Constant velocity (1,0);  Small diffusion coeff.
% James Liu, ColoState; 2012/07--2017/02 

D = 1e-3;  % Diffusion coefficient

EqnBC = struct('fxnv',@fxnv, 'D',D, 'fxnf',@fxnf, ...
  'fxncD',@fxncD, 'fxncN',@fxncN, ...
  'fxnc',@fxnc, 'fxncg',@fxncg);

% Known velocity field 
function v = fxnv(pt) 
  x = pt(:,1);  % y = pt(:,2);
  v = [ones(size(x)), zeros(size(x))];
end

% The right-hand function in the PDE 
function f = fxnf(pt)
  x = pt(:,1);  y = pt(:,2);
  f = pi*cos(pi*x).*sin(pi*y) + D*(2*pi*pi)*sin(pi*x).*sin(pi*y);
end

% Known exact concentration 
function c = fxnc(pt)
  x = pt(:,1);  y = pt(:,2);
  c = sin(pi*x) .* sin(pi*y);
end

% Dirichlet boundary condition for the concentration
function cD = fxncD(pt) 
  % x = pt(:,1);  y = pt(:,2);
  cD = fxnc(pt);
end

% Neumann boundary condition for the concentration 
% --None 

% Known exact concentration gradient 
function cg = fxncg(pt)
  x = pt(:,1);  y = pt(:,2);
  cg = [pi*cos(pi*x).*sin(pi*y), pi*sin(pi*x).*cos(pi*y)];
end

end