function EqnBC = EqnBC_Poisson_Ex61Aniso
%% EqnBC: Poisson: Anisotropy in diffusion: 1 piece
% Known exact pressure & source: A modification to EdwZheng_JCP_2008 Case2
% James Liu, ColoState; 2012/07--2017/02 

EqnBC = struct('fxnK',@fxnK, 'fxnf',@fxnf, ...
  'fxnpD',@fxnpD,'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnpg',@fxnpg, 'fxnu',@fxnu);

% Permeability as 2x2 SPD matrix 
function K = fxnK(pt)
  a = 0.246436002E+4;  b = 0.1148683643E+4;  d = 0.05366399794E+4;
  % x = pt(:,1);  y = pt(:,2);
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = a;  K(:,1,2) = b;  
  K(:,2,1) = b;  K(:,2,2) = d;
end

% The right-hand side function in the Poisson/Darcy equation
function f = fxnf(pt)
  x = pt(:,1);  y = pt(:,2);
  xc = 0.5;  yc = 0.5;  sigma2 = 0.005;
  tmp = (x-xc).^2 + (y-yc).^2;
  f = 1e5 * exp(-0.5/sigma2*tmp);
end

% Dirichlet boundary condition: Homogeneous
function pD = fxnpD(pt) 
  x = pt(:,1);  % y = pt(:,2);
  pD = zeros(size(x));
end

% Neumann boundary condition 
% None

% Exact "pressure" unknown or just set to 0 
function p = fxnp(pt)
  x = pt(:,1);  % y = pt(:,2);
  p = zeros(size(x));
end

% Exact pressure gradient unknown or just set to zero
function pg = fxnpg(pt) 
  % x = pt(:,1);  y = pt(:,2);
  pg = zeros(size(pt));
end

% Exact velocity UNKNOWN or just set to zero
function u = fxnu(pt) 
  u = zeros(size(pt));
end

end