function EqnBC = EqnBC_Poisson_Ex11sinsin
%% EqnBC: Poisson: A popular example on [0,1]^2:  p(x,y) = sin(pi x) sin(pi y)
% Homogeneous Dirichlet boundary condition 
% James Liu, ColoState; 2012/07--2017/02 

EqnBC = struct('fxnKs',@fxnKs, 'fxnK',@fxnK, 'fxnf',@fxnf, ...
  'fxnpD',@fxnpD, 'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnpg',@fxnpg, 'fxnu',@fxnu);

% Diffusion coeff. or permeability as a scalar 
function Ks = fxnKs(pt)
  x = pt(:,1);  % y = pt(:,2);
  Ks = ones(size(x));
end

% Diffusion coeff. or permeability as 2x2 SPD matrix 
function K = fxnK(pt)
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = 1;
  K(:,2,2) = 1;
end

% The right-hand sied function in the Poisson/Darcy equation
function f = fxnf(pt)
  x = pt(:,1);  y = pt(:,2);
  f = (2*pi*pi) * sin(pi*x) .* sin(pi*y);
end

% Dirichlet boundary condition
function pD = fxnpD(pt) 
  % x = pt(:,1);  y = pt(:,2);
  pD = fxnp(pt);
end

% Neumann boundary condition
% None 

% Known exact "pressure" solution 
function p = fxnp(pt)
  x = pt(:,1);  y = pt(:,2);
  p = sin(pi*x) .* sin(pi*y);
end

% Known gradient of the exact "pressure" solution 
function pg = fxnpg(pt) 
  x = pt(:,1);  y = pt(:,2);
  pg = [pi*cos(pi*x).*sin(pi*y), pi*sin(pi*x).*cos(pi*y)];
end

% Known exact solution for "velocity"
function u = fxnu(pt)
  x = pt(:,1);  y = pt(:,2);
  u1 = -pi*cos(pi*x).*sin(pi*y);
  u2 = -pi*sin(pi*x).*cos(pi*y);
  u = [u1,u2];
end

end