function EqnBC = EqnBC_Poisson_Ex10x2y2
%% EqnBC: Poisson: A simple example p(x,y)=x^2-y^2
% On the unit square [0,1]^2 with homogeneous Dirichlet boundary condition 
% James Liu, ColoState; 2012/07--2017/02 

EqnBC = struct('fxnKs',@fxnKs, 'fxnK',@fxnK, 'fxnf',@fxnf, ...
  'fxnpD',@fxnpD, 'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnpg',@fxnpg, 'fxnu',@fxnu);

% Diffusion coeff. or permeability as a scalar 
function Ks = fxnKs(pt)
  x = pt(:,1);  % y = pt(:,2);
  Ks = ones(size(x));
end

% Diffusion coeff. or permeability as a 2x2 SPD matrix 
function K = fxnK(pt)
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = 1;
  K(:,2,2) = 1;
end

% The right-hand sied function in the Poisson/Darcy equation
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary condition
function pD = fxnpD(pt) 
  % x = pt(:,1);  y = pt(:,2);
  pD = fxnp(pt);
end

% Neumann boundary condition
% None 

% Known exact "pressure" 
function p = fxnp(pt)
  x = pt(:,1);  y = pt(:,2);
  p = x.^2 - y.^2;
end

% Known exact "pressure" gradient
function pg = fxnpg(pt) 
  x = pt(:,1);  y = pt(:,2);
  pg = [2*x, -2*y];
end

% Known exact "velocity" 
function u = fxnu(pt)
  u = -[2*x, -2*y];
end

end