function EqnBC = EqnBC_Poisson_Ex10x1xy1y
%% EqnBC: Poisson: A simple example p(x,y)=x(1-x)y(1-y) 
% On the unit square [0,1]^2 with homogeneous Dirichlet boundary condition 
% James Liu, ColoState; 2012/07--2017/02 

EqnBC = struct('fxnKs',@fxnKs, 'fxnK',@fxnK, 'fxnf',@fxnf, ...
  'fxnpD',@fxnpD, 'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnpg',@fxnpg, 'fxnu',@fxnu);

% Diffusion coeff. or permeability as a scalar 
function Ks = fxnKs(pt)
  x = pt(:,1);  % y = pt(:,2);
  Ks = ones(size(x));
end

% Diffusion coeff. or permeability as a 2x2 SPD matrix 
function K = fxnK(pt)
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = 1;
  K(:,2,2) = 1;
end

% The right-hand sied function in the Poisson/Darcy equation
function f = fxnf(pt)
  x = pt(:,1);  y = pt(:,2);
  f = 2*(x.*(1-x)+y.*(1-y));
end

% Dirichlet boundary condition
function  pD = fxnpD(pt) 
  % x = pt(:,1);  y = pt(:,2);
  pD = fxnp(pt);
end

% Neumann boundary condition
% None 

% Known exact "pressure" 
function p = fxnp(pt)
  x = pt(:,1);  y = pt(:,2);
  p = x.*(1-x).*y.*(1-y);
end

% Known exact "pressure" gradient
function pg = fxnpg(pt) 
  x = pt(:,1);  y = pt(:,2);
  pg = [(1-2*x).*y.*(1-y), x.*(1-x).*(1-2*y)];
end

% Known exact "velocity"
function u = fxnu(pt) 
  x = pt(:,1);  y = pt(:,2);
  u = -[(1-2*x).*y.*(1-y), x.*(1-x).*(1-2*y)];
end

end