function EqnBC = EqnBC_Poisson_ArnoldBoffiFalkMCOM2002_Ex1
%% EqnBC: Poisson: On [0,1]^2  
% Cf. Arnold,Boffi,Falk, MCOM, 2012, p.918 
% p(x,y) = x^3 + 5y^2 - 10y^3 + y^4, Dirichlet bndry.cond. 
% James Liu, ColoState; 2012/07--2017/02 

EqnBC = struct('fxnKs',@fxnKs, 'fxnK',@fxnK, 'fxnf',@fxnf, ...
  'fxnpD',@fxnpD, 'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnpg',@fxnpg, 'fxnu',@fxnu);

% Diffusion coeff. or permeability as a scalar 
function Ks = fxnKs(pt)
  x = pt(:,1);  % y = pt(:,2);
  Ks = ones(size(x));
end

% Diffusion coeff. or permeability as 2x2 SPD matrix 
function K = fxnK(pt)
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = 1;
  K(:,2,2) = 1;
end

% The right-hand sied function in the Poisson/Darcy equation
function f = fxnf(pt)
  x = pt(:,1);  y = pt(:,2);
  f = -(6*x+10-60*y+12*y.*y);
end

% Dirichlet boundary condition
function pD = fxnpD(pt) 
  % x = pt(:,1);  y = pt(:,2);
  pD = fxnp(pt);
end

% Neumann boundary condition
% None 

% Known exact "pressure" solution 
function p = fxnp(pt)
  x = pt(:,1);  y = pt(:,2);
  p = x.^3 + 5*y.^2 - 10*y.^3 + y.^4;
end

% Known gradient of the exact "pressure" solution 
function pg = fxnpg(pt) 
  x = pt(:,1);  y = pt(:,2);
  pg = [3*x.^2, 10*y-30*y.^2+4*y.^3];
end

% Known exact "velocity" solution 
function u = fxnu(pt)
  x = pt(:,1);  y = pt(:,2);
  u1 = - 3*x.^2;
  u2 = - (10*y-30*y.^2+4*y.^3);
  u = [u1,u2];
end

end