function EqnBC = EqnBC_LinElas_YiM3AS2006_Ex2
%% EqnBC: Linear Elasticity: Cf. Yi_M3AS_2006, Ex.2, p.997 
% Example on (0,1)^2 
% James Liu, Zhuoran Wang, ColoState; 2012/07--2017/02 

% These parameters are allowed to change 
lambda = 1; 
mu = 0.5; 

EqnBC = struct('lambda',lambda, 'mu',mu, ...
  'fxnf',@fxnf, 'fxnuD',@fxnuD, ...
  'fxnu',@fxnu, 'fxndivu',@fxndivu);

% The right-hand side vector function in the linear elasticity equation
function f = fxnf(pt)
  x = pt(:,1);  y = pt(:,2); 
  % James Liu: This one is correct: Derived from 
  % f = -(mu*Delta u + (mu+lambda) \nabla (nabla \cdot u)) 
  dxdxu1 = exp(x-y) .* (-3*x-x.^2) .* y.*(1-y);
  dydyu1 = exp(x-y) .* x.*(1-x) .* (-4+5*y-y.^2);
  Deltau1 = dxdxu1 + dydyu1;  % Laplacian acting on u1 
  Deltau2 = -2*pi*pi* sin(pi*x).*sin(pi*y);
  Deltau = [Deltau1, Deltau2];  % Laplacian acting on u 
  graddivu = [exp(x-y).*(-3*x-x.^2).*y.*(1-y) + pi*pi*cos(pi*x).*cos(pi*y),...
              exp(x-y).*(1-x-x.^2).*(1-3*y+y.^2) - pi*pi*sin(pi*x).*sin(pi*y)];
  f = mu*Deltau + (mu+lambda)*graddivu;
  f = -f;

%   % Zhuoran Wang: Derived from: -div(sigma(u)) = f 
%   f1 = - (2*mu+lambda) * exp(x-y) .* (-x.^2-3*x) .* y.*(1-y) ...
%        - lambda * (pi^2) * cos(pi*x).*cos(pi*y) ...
%        + mu * exp(x-y) .* x.*(1-x) .* (y.^2-5*y+4) ...
%        - mu * (pi^2) * cos(pi*x).*cos(pi*y);
%   f2 = - mu * exp(x-y) .* (1+x-x.^2) .* (1-3*y+y.^2) ...
%        + mu * (pi^2) * sin(pi*x).*sin(pi*y)...
%        + (2*mu+lambda) * (pi^2) * sin(pi*x).*sin(pi*y) ...
%        + lambda * exp(x-y) .* (1-x-x.^2) .* (-1+3*y-y.^2);
%   f = [f1,f2];

% Zhuoran Wang: calculate by hand, -mu*(lap(u)) - (mu+lambda)*grad(div(u)) = f
%       f = [-mu*exp(x - y).*(1 - y).*y.*(-x.^2 - 3*x) + ...
%            mu*exp(x - y).*x.*(1 - x).*(4 + y.^2 - 5*y) -...
%           (mu + lambda)*exp(x - y).*(1 - y).*y*(-x.^2 + 1 - x) -...
%           (mu + lambda)*exp(x - y).*(1 - y).*y.*(-2*x - 1) -...
%           (mu + lambda)*(pi^2)*cos(pi*x).*cos(pi*y);
%           
%           2*(pi^2)*mu*sin(pi*x).*sin(pi*y) + ...
%           (mu + lambda)*exp(x - y).*(1 - y).*y.*(-x.^2 + 1 - x) -...
%           (mu + lambda)*exp(x - y).*(1 - y).*(1 - x.^2 - x) + ...
%           (mu + lambda)*exp(x - y).*y.*(-x.^2 + 1 - x)+...
%           (mu + lambda)*(pi^2)*sin(pi*x).*sin(pi*y)
%           ];
    
% Zhuoran Wang: calculate by matlab
%   f = [ - lambda*((pi^2)*cos(pi*x).*cos(pi*y) + ...
%         2*y.*exp(x - y).*(y - 1) + ...
%         2*x.*y.*exp(x - y).*(y - 1) + ...
%         2*y.*exp(x - y).*(x - 1).*(y - 1) + ...
%         x.*y.*exp(x - y).*(x - 1).*(y - 1)) - ...
%         2*mu*(((pi^2)*cos(pi*x).*cos(pi*y))/2 + ...
%         (x.*exp(x - y).*(x - 1).*(y.^2 - 3*y + 1))/2 - ...
%         (x.*exp(x - y).*(2*y - 3).*(x - 1))/2) - ...
%         2*mu*y.*exp(x - y).*(2*x + 1).*(y - 1) - ...
%         2*mu*y.*exp(x - y).*(y - 1).*(x.^2 + x - 1);
%         
%         2*mu*(((pi^2)*sin(pi*x).*sin(pi*y))/2 + ...
%         (exp(x - y).*(x - 1).*(y.^2 - 3*y + 1))/2 + ...
%         (x.*exp(x - y).*(y.^2 - 3*y + 1))/2 + ...
%         (x.*exp(x - y).*(x - 1).*(y.^2 - 3*y + 1))/2) - ...
%         lambda*(exp(x - y).*(x - 1).*(y - 1) - ...
%         (pi^2)*sin(pi*x).*sin(pi*y) + x.*y.*exp(x - y) +...
%         x.*exp(x - y).*(y - 1) + y.*exp(x - y).*(x - 1) +...
%         x.*y.*exp(x - y).*(x - 1) - ...
%         x.*y.*exp(x - y).*(y - 1) + x.*exp(x - y).*(x - 1).*(y - 1) - ...
%         y.*exp(x - y).*(x - 1).*(y - 1) - ...
%         x.*y.*exp(x - y).*(x - 1).*(y - 1)) + ...
%         2*(pi^2)*mu*sin(pi*x).*sin(pi*y)
%         ]; 
end

% Dirichlet boundary condition
function uD = fxnuD(pt) 
  % x = pt(:,1);  y = pt(:,2);
  uD = fxnu(pt);
end

% Neumann boundary condition
% None 

% Known analytical solution for displacement 
function u = fxnu(pt)
  x = pt(:,1);  y = pt(:,2);
  u1 = exp(x-y) .* x.*(1-x) .* y.*(1-y);
  u2 = sin(pi*x) .* sin(pi*y);
  u = [u1,u2];
end

% Known analytical solution for divergence of displacement 
function divu = fxndivu(pt)
  x = pt(:,1);  y = pt(:,2);
  divu = exp(x-y) .* (1-x-x.^2) .* y.*(1-y) + pi*sin(pi*x).*cos(pi*y);
end

end