function EqnBC = EqnBC_LinElas_Liu_Ex2
%% EqnBC: Linear Elasticity: Liu: Simple examples 
% Ex.2 on [0,1]^2: Dirichlet bndry.cond. on the whole boundary 
% James Liu, ColoState; 2012/07--2021/02 

% Parameters 
lambda = 1;
mu = 1;

EqnBC = struct('lambda',lambda, 'mu',mu, ...
  'fxnf',@fxnf, 'fxnuD',@fxnuD, 'fxntN',@fxntN, ...
  'fxnu',@fxnu, 'fxndivu',@fxndivu, 'fxnsigma',@fxnsigma, ...
  'fxnug',@fxnug);

% The RHS / body force 
function f = fxnf(pt)
  f = zeros(size(pt));
  f(:,1) = -(6*mu+4*lambda);
end

% Dirichlet boundary conditions 
function uD = fxnuD(pt) 
  uD = fxnu(pt);
end

% % Neumann boundary conditions: NONE
% function tN = fxntN(pt) 
% end

% Known analytical solution for displacement 
function u = fxnu(pt)
  x = pt(:,1);  y = pt(:,2);
  u = [x.^2, 2*x.*y];
end

% Known analytical solution for dilation (divergence of displacement) 
function divu = fxndivu(pt)
  x = pt(:,1);  % y = pt(:,2);
  divu = 4*x;
end

% Known analytical solution for stress 
function sigma = fxnsigma(pt) 
  x = pt(:,1);  y = pt(:,2);
  NumPts = size(pt,1);
  sigma = zeros(NumPts,2,2);
  sigma(:,1,1) = 4*(mu+lambda)*x;
  sigma(:,1,2) = 2*mu*y;
  sigma(:,2,1) = sigma(:,1,2);
  sigma(:,2,2) = sigma(:,1,1);
end

% Known analytical solution for displacement gradient  
function ug = fxnug(pt) 
  x = pt(:,1);  y = pt(:,2);
  NumPts = size(pt,1);
  ug = zeros(NumPts,2,2);
  ug(:,1,1) = 2*x;
  ug(:,2,1) = 2*y;
  ug(:,2,2) = 2*x;
end

end