function EqnBC = EqnBC_LinElas_Liu_Ex1
%% EqnBC: Linear Elasticity: Liu: Simple examples 
% Ex.1 on [0,1]^2: Dirichlet bndry.cond. on the whole boundary 
% James Liu, ColoState; 2012/07--2021/02 

% Parameters 
lambda = 1;
mu = 1;

EqnBC = struct('lambda',lambda, 'mu',mu, ...
  'fxnf',@fxnf, 'fxnuD',@fxnuD, 'fxntN',@fxntN, ...
  'fxnu',@fxnu, 'fxndivu',@fxndivu, 'fxnsigma',@fxnsigma, ...
  'fxnug',@fxnug);

% The RHS / body force 
function f = fxnf(pt)
  % x = pt(:,1);  y = pt(:,2);
  f = zeros(size(pt));
end

% Dirichlet boundary conditions 
function uD = fxnuD(pt) 
  uD = fxnu(pt);
end

% % Neumann boundary conditions: NONE
% function tN = fxntN(pt) 
%   tN = 0;
% end

% Known analytical solution for displacement 
function u = fxnu(pt)
  x = pt(:,1);  y = pt(:,2);
  u = [x,y];
end

% Known analytical solution for dilation (divergence of displacement) 
function divu = fxndivu(pt)
  divu = 2;
end

% Known analytical solution for stress 
function sigma = fxnsigma(pt) 
  % x = pt(:,1);  y = pt(:,2);
  NumPts = size(pt,1);
  sigma = zeros(NumPts,2,2);
  sigma(:,1,1) = 2*mu + 2*lambda;
  sigma(:,2,2) = 2*mu + 2*lambda;
end

% Known analytical solution for displacement gradient  
function ug = fxnug(pt) 
  % x = pt(:,1);  y = pt(:,2);
  NumPts = size(pt,1);
  ug = zeros(NumPts,2,2);
  ug(:,1,1) = 1;
  ug(:,2,2) = 1;
end

end