function EqnBC = EqnBC_Darcy_Ex31AnisoPerm
%% EqnBC: Darcy: Heterogeneous permeability 
% Example on the unit square with a heterogeneous permeability 
% James Liu, ColoState; 2012/07--2017/02 

% These parameters can be adjusted 
alpha = 100;  
beta = -9;

EqnBC = struct('fxnK',@fxnK, 'fxnf',@fxnf, ...
  'fxnpD',@fxnpD, 'fxnuN',@fxnuN, ...
  'fxnp',@fxnp, 'fxnpg',@fxnpg, 'fxnu',@fxnu);

% Permeability as a 2x2 SPD matrix 
function K = fxnK(pt)
  NumPts = size(pt,1);
  K = zeros(NumPts,2,2);
  K(:,1,1) = 1;  K(:,1,2) = beta;  K(:,2,1) = beta;  K(:,2,2) = alpha;
end

% Source (the right-hand function)
function f = fxnf(pt)
  x = pt(:,1);  % y = pt(:,2);
  f = zeros(size(x));
end

% Dirichlet boundary conditions
function pD = fxnpD(pt) 
  x = pt(:,1);  % y = pt(:,2);
  bnd0 = (x==0);
  bnd1 = (x==1);
  pD = 1*bnd0 + 0*bnd1;
end

% Neumann boundary conditions
function uN = fxnuN(pt)
  % x = pt(:,1);  
  y = pt(:,2);
  bnd = (y==0 | y==1);
  uN = 0*bnd;
end

% Exact pressure UNKNOWN or just set to zero
function p = fxnp(pt)
  x = pt(:,1);  % y = pt(:,2);
  p = zeros(size(x));
end

% Exact pressure gradient UNKNOWN or just set to zero
function pg = fxnpg(pt) 
  % x = pt(:,1);  y = pt(:,2);
  pg = zeros(size(pt));
end

% Exact velocity UNKNOWN or just set to zero
function u = fxnu(pt) 
  u = zeros(size(pt));
end

end